#include "lzw.h"

#include <fstream>

std::string readfile(const char *name)
{
	std::ifstream infile( name, std::ios::in | std::ios::binary );
	std::string result;

	while (true)
	{
		char c = infile.get();
		if (infile.eof())
			break;
		result += c;
	}

	return result;
}

int main(int argc, char *argv[])
{
	if (argc != 2)
	{
		std::cout << "Usage : lzw file\n";
		return 1;
	}

	std::string file = readfile(argv[1]);
	std::string buffer;
	std::string exit;

	{
		LZWCompressor lzw;
		lzw.compress(file, buffer);
	}

	{
		LZWCompressor lzw;
		lzw.expand(buffer, exit);
	}

	std::cout << "File Size            = " << file.size() << std::endl
	          << "Compressed File Size = " << buffer.size() << std::endl
			  << "Expanded File Size   = " << exit.size() << std::endl
			  << "Compression Rate     = " << (exit.size()-buffer.size())*100/exit.size() << "%\n";

	if (file == exit)
		std::cout << "Compression Well Done :)\n";
	else
		std::cout << "Compression Bad Done :(\n";

}
