#ifndef __address_space_h
#define __address_space_h

#include <config.h>

__BEGIN_SYS
__BEGIN_INT

class Address_Space
{
public:
    Address_Space();
    Address_Space(const Id & id);
    Address_Space(const Address_Space & as);
    ~Address_Space();

    const Id & id();
    bool valid();

    // methods
};

class Flat
{
public:
    Flat();
    Flat(const Id & id);
    Flat(const Flat & as);
    ~Flat();

    const Id & id();
    bool valid();

    // methods
};

class Paged
{
public:
    Paged();
    Paged(const Id & id);
    Paged(const Paged & as);
    ~Paged();

    const Id & id();
    bool valid();

    // methods
};

__END_INT
__END_SYS

#ifdef __FLAT_H
#include __FLAT_H
#endif

#ifdef __PAGED_H
#include __PAGED_H
#endif

#ifdef __FRAMEWORK_H
#include  __FRAMEWORK_H
#endif

#endif

