#ifndef __config_h
#define __config_h

#include <system/config.h>
#include <system/info.h>
#include <system/debugger.h>

//============================================================================
// APPLICATION-SPECIFIC CONFIGURATION
//============================================================================
#ifndef ANALYZE
#ifdef CONFIG_KEYS
#include CONFIG_KEYS
#else
#include "default.key"
#endif
#endif

//============================================================================
// FRAMEWORK
//============================================================================
#ifndef ANALYZE

#if #CONF_FRAMEWORK (Uniform)
#define __FRAMEWORK_H __HEADER_FMK(uniform)

#elif #CONF_FRAMEWORK (Individual)
#define __FRAMEWORK_H __HEADER_FMK(individual)

#else
#error Configuration: "Framework" not selected!
#endif

#endif

//============================================================================
// ID							
//============================================================================
__EXPORT_ASP(Id, Pointer)
__EXPORT_ASP(Id, Local)
__EXPORT_ASP(Id, Global)
__EXPORTN_ASP(Id, Capability)

#ifdef ANALYZE
__UNBIND(Id)
#else

#if #CONF_ID (Not_Needed)
#assert CONF_ID (Local)
#endif

#if #CONF_ID (Pointer)
#define	__POINTER_ID_H __HEADER_ASP(id/pointer)
__BIND(Id, Pointer)

#elif #CONF_ID (Local)
#define	__LOCAL_ID_H __HEADER_ASP(id/local)
__BIND(Id, Local)

#elif #CONF_ID (Global)
#define	__GLOBAL_ID_H __HEADER_ASP(id/global)
__BIND(Id, Global)

#elif #CONF_ID (Capability)
#define	__CAPABILITY_H __HEADER_ASP(id/capability)
__BINDN(Id, Capability)

#else
#error Configuration: "Id" not selected!
#endif	

#endif

//============================================================================
// NODE								
//============================================================================
__EXPORTN_MED(Node, SP_PC)
__EXPORTN_MED(Node, MP_PC)

#ifdef ANALYZE
__UNBIND(Node)
#else

#if #CONF_NODE (Not_Needed)

#elif #CONF_NODE (SP_PC)
__BINDN_MED (Node, SP_PC)
#define	__SP_PC_H __HEADER_MED(node/sp_pc)

#elif #CONF_NODE (MP_PC)
__BINDN_MED (Node, MP_PC)
#define	__MP_PC_H __HEADER_MED(node/mp_pc)

#else
#warning Configuration: "Node" not selected!
#endif

#endif

//============================================================================
// CPU								
//============================================================================
__EXPORTN_MED(CPU, Ix86)
__EXPORTN_MED(CPU, LANai)

#ifdef ANALYZE
__UNBIND(CPU)
#else

#if #CONF_CPU (Not_Needed)

#elif #CONF_CPU (Ix86)
__BINDN_MED (CPU, Ix86)
#define	__IX86_H __HEADER_MED(cpu/ix86)

#elif #CONF_CPU (LANai)
__BIND_MED (CPU, LANai)
#define	__LANAI_H __HEADER_MED(cpu/lanai)

#else
#warning Configuration: "CPU" not selected!
#endif

#endif

//============================================================================
// ADDRESS_SPACE
//============================================================================
__EXPORTN_ABS(Address_Space, Flat)
__EXPORTN_ABS(Address_Space, Paged)

#ifdef ANALYZE
__UNBIND(Address_Space)
#else

#if #CONF_ADDRESS_SPACE (Flat)
__BINDN (Address_Space, Flat)
#define	__FLAT_H __HEADER_ABS(address_space/flat)

#elif #CONF_ADDRESS_SPACE (Paged)
__BINDN (Address_Space, Paged)
#define	__PAGED_H __HEADER_ABS(address_space/paged)

#else
#warning Configuration: "Address_Space" not selected!
#endif

#endif

//============================================================================
// BUS
//============================================================================
__EXPORTN_ABS(Bus, PCI)

#ifdef ANALYZE
__UNBIND(Bus)
#else

#if #CONF_BUS (PCI)
__BINDN (Bus, PCI)
#define	__PCI_H __HEADER_ABS(bus/pci)

#else
#warning Configuration: "Bus" not selected!
#endif

#endif

//============================================================================
// CHANNEL								
//============================================================================
__EXPORTN_ABS(Channel, Stream)
__EXPORTN_ABS(Channel, Datagram)
__EXPORTN_ABS(Channel, AM)

#ifdef ANALYZE
__UNBIND(Channel)
#else

#if ! #CONF_CHANNEL
#warning Configuration: "Channel" not selected!
#endif

#if #CONF_CHANNEL (Stream)
#if ! #BOUND (Channel)
__BINDN (Channel, Stream)
#assert	BOUND (Channel)
#endif
#define	__STREAM_H __HEADER_ABS(channel/stream)
#endif

#if #CONF_CHANNEL (Datagram)
#if ! #BOUND (Channel)
__BINDN (Channel, Datagram)
#assert	BOUND (Channel)
#endif
#define	__DATAGRAM_H __HEADER_ABS(channel/datagram)
#endif

#if #CONF_CHANNEL (AM)
#if ! #BOUND (Channel)
__BINDN (Channel, AM)
#assert	BOUND (Channel)
#endif
#define	__AM_H __HEADER_ABS(channel/am)
#endif

#endif

//============================================================================
// COMMUNICATOR								
//============================================================================
__EXPORTN_ABS(Communicator, Link)
__EXPORTN_ABS(Communicator, Port)
__EXPORTN_ABS(Communicator, Mailbox)
__EXPORTN_ABS(Communicator, ARM_Segment)
__EXPORTN_ABS(Communicator, AM_Handler)

#ifdef ANALYZE
__UNBIND(Communicator)
#else

#if ! #CONF_COMMUNICATOR
#warning Configuration: "Communicator" not selected!
#endif

#if #CONF_COMMUNICATOR (Link)
#if ! #BOUND (Communicator)
__BINDN (Communicator, Link)
#assert	BOUND (Communicator)
#endif
#define	__LINK_H __HEADER_ABS(communicator/link)
#endif

#if #CONF_COMMUNICATOR (Port)
#if ! #BOUND (Communicator)
__BINDN (Communicator, Port)
#assert	BOUND (Communicator)
#endif
#define	__PORT_H __HEADER_ABS(communicator/port)
#endif

#if #CONF_COMMUNICATOR (Mailbox)
#if ! #BOUND (Communicator)
__BINDN (Communicator, Mailbox)
#assert	BOUND (Communicator)
#endif
#define	__MAILBOX_H __HEADER_ABS(communicator/mailbox)
#endif

#if #CONF_COMMUNICATOR (ARM_Segment)
#if ! #BOUND (Communicator)
__BINDN (Communicator, ARM_Segment)
#assert	BOUND (Communicator)
#endif
#define	__ARM_SEGMENT_H __HEADER_ABS(communicator/arm_segment)
#endif

#if #CONF_COMMUNICATOR (AM_Handler)
#if ! #BOUND (Communicator)
__BINDN (Communicator, AM_Handler)
#assert	BOUND (Communicator)
#endif
#define	__AM_HANDLER_H __HEADER_ABS(communicator/am_handler)
#endif

#endif

//============================================================================
// ENVELOPE
//============================================================================
__EXPORT_ABS(Envelope, Untyped)
__EXPORT_ABS(Envelope, Typed)

#ifdef ANALYZE
__UNBIND(Envelope)
#else

#if ! #CONF_ENVELOPE
#warning Configuration: "Envelope" not selected!
#endif

#if #CONF_ENVELOPE (Untyped)
#if ! #BOUND (Envelope)
__BIND (Envelope, Untyped)
#assert	BOUND (Envelope)
#endif
#define	__UNTYPED_ENVELOPE_H __HEADER_ABS(envelope/untyped)
#endif

#if #CONF_ENVELOPE (Typed)
#if ! #BOUND (Envelope)
__BIND (Envelope, Typed)
#assert	BOUND (Envelope)
#endif
#define	__TYPED_ENVELOPE_H __HEADER_ABS(envelope/typed)
#endif

#endif

//============================================================================
// HANDLER
//============================================================================
__EXPORT_ABS(Handler, Function)
__EXPORT_ABS(Handler, Thread)
__EXPORT_ABS(Handler, Semaphore)

#ifdef ANALYZE
__UNBIND(Handler)
#else

#if ! #CONF_HANDLER
#warning Configuration: "Handler" not selected!
#endif

#if #CONF_HANDLER (Function)
#if ! #BOUND (Handler)
__BIND (Handler, Function)
#assert	BOUND (Handler)
#endif
#define	__FUNCTION_HANDLER_H __HEADER_ABS(handler/function)
#endif

#if #CONF_HANDLER (Thread)
#if ! #BOUND (Handler)
__BIND (Handler, Thread)
#assert	BOUND (Handler)
#endif
#define	__THREAD_HANDLER_H __HEADER_ABS(handler/thread)
#endif

#if #CONF_HANDLER (Semaphore)
#if ! #BOUND (Handler)
__BIND (Handler, Semaphore)
#assert	BOUND (Handler)
#endif
#define	__SEMAPHORE_HANDLER_H __HEADER_ABS(handler/semaphore)
#endif

#endif

//============================================================================
// NETWORK								
//============================================================================
__EXPORTN_ABS(Network, Loop)
__EXPORTN_ABS(Network, Ethernet)
__EXPORTN_ABS(Network, Myrinet)

#ifdef ANALYZE
__UNBIND(Network)
#else

#define __NETWORK_H __HEADER_ABS(network/common) 

#if ! #CONF_NETWORK
#warning Configuration: "Network" not selected!
#endif

#if #CONF_NETWORK (Loop)
#if ! #BOUND (Network)
__BINDN (Network, Loop)
#assert	BOUND (Network)
#endif
#define	__LOOP_H __HEADER_ABS(network/loop)
#endif

#if #CONF_NETWORK (Ethernet)
#if ! #BOUND (Network)
__BINDN (Network, Ethernet)
#assert	BOUND (Network)
#endif
#define	__ETHERNET_H __HEADER_ABS(network/ethernet)
#endif

#if #CONF_NETWORK (Myrinet)
#if ! #BOUND (Network)
__BINDN (Network, Myrinet)
#assert	BOUND (Network)
#endif
#define	__MYRINET_H __HEADER_ABS(network/myrinet)
#endif

#endif

//============================================================================
// SEGMENT
//============================================================================
__EXPORT_ABS(Segment, Static)
__EXPORT_ABS(Segment, Dynamic)

#ifdef ANALYZE
__UNBIND(Segment)
#else

#if #CONF_SEGMENT (Static)
__BIND (Segment, Static)
#define	__STATIC_SEGMENT_H __HEADER_ABS(segment/static)

#elif #CONF_SEGMENT (Dynamic)
__BIND (Segment, Dynamic)
#define	__DYNAMIC_SEGMENT_H __HEADER_ABS(segment/dynamic)

#else
#warning Configuration: "Segment" not selected!
#endif

#endif

//============================================================================
// SYNCHRONIZER								
//============================================================================
__EXPORTN_ABS(Synchronizer, Mutex)
__EXPORTN_ABS(Synchronizer, Condition)
__EXPORTN_ABS(Synchronizer, Semaphore)

#ifdef ANALYZE
__UNBIND(Synchronizer)
#else

#if ! #CONF_SYNCHRONIZER
#warning Configuration: "Synchronizer" not selected!
#endif

#if #CONF_SYNCHRONIZER (Mutex)
#if ! #BOUND (Synchronizer)
__BINDN (Synchronizer, Mutex)
#assert	BOUND (Synchronizer)
#endif
#define	__MUTEX_H __HEADER_ABS(synchronizer/mutex)
#endif

#if #CONF_SYNCHRONIZER (Semaphore)
#if ! #BOUND (Synchronizer)
__BINDN (Synchronizer, Semaphore)
#assert	BOUND (Synchronizer)
#endif
#define	__SEMAPHORE_H __HEADER_ABS(synchronizer/semaphore)
#endif

#if #CONF_SYNCHRONIZER (Condition)
#if ! #BOUND (Synchronizer)
__BINDN (Synchronizer, Condition)
#assert	BOUND (Synchronizer)
#endif
#define	__CONDITION_H __HEADER_ABS(synchronizer/condition)
#endif

#endif

//============================================================================
// TASK								
//============================================================================
__EXPORT_ABS(Task, Exclusive)
__EXPORT_ABS(Task, Mutual)

#ifdef ANALYZE
__UNBIND(Task)
#else

#define __TRHEAD_H __HEADER_ABS(task/common)

#if #CONF_TASK (Not_Needed)

#elif #CONF_TASK (Exclusive)
__BIND (Task, Exclusive)
#define	__EXCLUSIVE_TASK_H __HEADER_ABS(task/exclusive)

#elif #CONF_TASK (Mutual)
__BIND (Task, Mutual)
#define	__MUTUAL_TASK_H __HEADER_ABS(task/mutual)

#else
#warning Configuration: "Task" not selected!
#endif

#endif

//============================================================================
// THREAD								
//============================================================================
__EXPORT_ABS(Thread, Exclusive)
__EXPORT_ABS(Thread, Cooperative)
__EXPORT_ABS(Thread, Concurrent)

#ifdef ANALYZE
__UNBIND(Thread)
#else

#if #CONF_THREAD (Not_Needed)

#elif #CONF_THREAD (Exclusive)
__BIND (Thread, Exclusive)
#define	__EXCLUSIVE_THREAD_H __HEADER_ABS(thread/exclusive)

#elif #CONF_THREAD (Cooperative)
__BIND (Thread, Cooperative)
#define	__COOPERATIVE_THREAD_H __HEADER_ABS(thread/cooperative)

#elif #CONF_THREAD (Concurrent)
__BIND (Thread, Concurrent)
#define	__CONCURRENT_THREAD_H __HEADER_ABS(thread/concurrent)

#else
#warning Configuration: "Thread" not selected!
#endif

#endif

//============================================================================
// TIMER
//============================================================================
__EXPORTN_ABS(Timer, Clock)
__EXPORTN_ABS(Timer, Alarm)
__EXPORTN_ABS(Timer, Chronometer)

#ifdef ANALYZE
__UNBIND(Timer)
#else

#if ! #CONF_TIMER
#warning Configuration: "Timer" not selected!
#endif

#if #CONF_TIMER (Clock)
#if ! #BOUND (Timer)
__BINDN (Timer, Clock)
#assert	BOUND (Timer)
#endif
#define	__CLOCK_H __HEADER_ABS(timer/clock)
#endif

#if #CONF_TIMER (Alarm)
#if ! #BOUND (Timer)
__BINDN (Timer, Alarm)
#assert	BOUND (Timer)
#endif
#define	__ALARM_H __HEADER_ABS(timer/alarm)
#endif

#if #CONF_TIMER (Chronometer)
#if ! #BOUND (Timer)
__BINDN (Timer, Chronometer)
#assert	BOUND (Timer)
#endif
#define	__CHRONOMETER_H __HEADER_ABS(timer/chronometer)
#endif

#endif

//============================================================================
// THINGS EVERBODY NEEDS
//============================================================================
#include <id.h>

#ifndef ANALYZE
#include <traits.h>
#endif

#endif


