#ifndef __id_h
#define __id_h

#include <system/config.h>
#include <node.h>

__BEGIN_SYS

// Identifies the type of an abstraction
typedef unsigned short Type_Id;
enum 
{
    ADDRESS_SPACE = 0,
    FLAT = ADDRESS_SPACE,
    PAGED = ADDRESS_SPACE,

    CHANNEL,
    STREAM = CHANNEL,
    DATAGRAM,
    ACTIVE,

    COMMUNICATOR,
    LINK = COMMUNICATOR,
    PORT,
    MAILBOX,
    ARM_SEGMENT,
    AM_HANDLER,

    ENVELOPE,
    UNTYPED_ENVELOPE = ENVELOPE,
    TYPED_ENVELOPE,

    HANDLER,
    FUNCTION_HANDLER = HANDLER,
    THREAD_HANDLER,
    SEMAPHORE_HANDLER,

    NETWORK,
    LOOP = NETWORK,
    ETHERNET,
    MYRINET,

    SEGMENT,
    STATIC_SEGMENT = SEGMENT,
    DYNAMIC_SEGMENT = SEGMENT,

    SYNCHRONIZER,
    MUTEX = SYNCHRONIZER,
    SEMAPHORE,
    CONDITION,

    TASK,
    EXCLUSIVE_TASK = TASK,
    MUTUAL_TASK = TASK,

    THREAD,
    EXCLUSIVE_THREAD = THREAD,
    COOPERATIVE_THREAD = THREAD,
    CONCURRENT_THREAD = THREAD,

    TIMER,
    CLOCK = TIMER,
    ALARM,
    CHRONOMETER,

    DUMMY_TYPE,

    LAST_TYPE = DUMMY_TYPE - 1,
    ANY_TYPE = 0xffff
};

// enum 
// {
//     AS = 0,
//     FLAT = AS,
//     PAGED = AS,

//     CHAN,
//     STR = CHAN,
//     DGRAM,
//     ACTM,

//     COMM,
//     LINK = COMM,
//     PORT,
//     MBOX,
//     ARMS,
//     AMH,

//     ENV,
//     UENV = ENV,
//     TENV,

//     HAN,
//     FHAN = HAN,
//     THAN,
//     SHAN,

//     NET,
//     LOOP = NET,
//     ETH,
//     MYRI,

//     SEG,
//     SSEG = SEG,
//     DSEG = SEG,

//     SYNC,
//     MUTEX = SYNC,
//     SEM,
//     COND,

//     TASK,
//     ETSK = TASK,
//     MTSK = TASK,

//     THR,
//     ETHR = THR,
//     PTHR = THR,
//     CTHR = THR,

//     TIMER,
//     CLOCK = TIMER,
//     ALARM,
//     CHRON,

//     DUMMY_TYPE,

//     LAST_TYPE = DUMMY_TYPE - 1,
//     ANY_TYPE = 0xffff
// };

// Identifies an instance of an abstraction
typedef unsigned short Unit;
enum {ANY_UNIT = 0xffff};

// Makes an id sparse
typedef int Random;

// Designate the permissions over an instace
typedef unsigned short Rights;
enum {ALL_RIGHTS = 0xffff};

__BEGIN_INT

class Id
{
public:
    Id(const Type_Id & type);
    Id(const Type_Id & type, const Unit & unit);
    Id(const Type_Id & type, const Unit & unit, const Node_Id & host);
    Id(const Type_Id & type, const Unit & unit, const Node_Id & host,
       const Rights & rights);
    ~Id();
};

class Pointer {};

class Local_Id
{
public:
    Local_Id(const Type_Id & type, const Unit & unit = ANY_UNIT);
    ~Local_Id();
};

class Global_Id
{
public:
    Global_Id(const Type_Id & type, const Unit & unit = ANY_UNIT, 
	      const Node_Id & host = LOCAL_NODE);
    ~Global_Id();
};

class Capability
{
public:
    Capability(const Type_Id & type, const Unit & unit = ANY_UNIT, 
	       const Node_Id & host = LOCAL_NODE, 
	       const Rights & rights = ALL_RIGHTS);
    ~Capability();

    Random getRand();
};

__END_INT
__END_SYS

#ifdef __POINTER_H
#include __POINTER_H
#endif

#ifdef __LOCAL_ID_H
#include __LOCAL_ID_H
#endif

#ifdef __GLOBAL_ID_H
#include __GLOBAL_ID_H
#endif

#ifdef __CAPABILITY_H
#include __CAPABILITY_H
#endif

#endif

