#ifndef __individual_h
#define __individual_h

#include <traits.h>

//============================================================================
// DEBUGGED							
//============================================================================
#define __WATCHED_H __HEADER_ASP(debugged/watched)
#define __TRACED_H __HEADER_ASP(debugged/traced)
#define __PROFILED_H __HEADER_ASP(debugged/profiled)
#include <debugged.h>

__BEGIN_SYS

template<Aspect asp>
class Debugged: public __INT(Debugged) {};
template<>
class Debugged<WATCHED>: public Watched {};
template<>
class Debugged<TRACED>: public Traced {};
template<>
class Debugged<PROFILED>: public Profiled {};

__END_SYS

//============================================================================
// SHARED							
//============================================================================
#define __REFERENCED_H __HEADER_ASP(shared/referenced)
#define __ENROLLED_H __HEADER_ASP(shared/enrolled)
#include <shared.h>

__BEGIN_SYS

template<Aspect asp>
class Shared: public __INT(Shared) {};
template<>
class Shared<REFERENCED>: public Referenced {};
template<>
class Shared<ENROLLED>: public Enrolled {};

__END_SYS

//============================================================================
// ALLOCATED							
//============================================================================
#define __AHEAD_H __HEADER_ASP(allocated/ahead)
#define __LATE_H __HEADER_ASP(allocated/late)
#include <allocated.h>

__BEGIN_SYS

template<Aspect asp>
class Allocated: public __INT(Allocated) {};
template<>
class Allocated<AHEAD>: public Ahead_Allocated {};
template<>
class Allocated<LATE>: public Late_Allocated {};

__END_SYS

//============================================================================
// PROTECTED							
//============================================================================
#define __CHECKED_H __HEADER_ASP(protected/checked)
#define __PERMITTED_H __HEADER_ASP(protected/permitted)
#include <protected.h>

__BEGIN_SYS

template<Aspect asp>
class Protected: public __INT(Protected) {};
template<>
class Protected<CHECKED>: public Checked {};
template<>
class Protected<PERMITTED>: public Permitted {};

__END_SYS

//============================================================================
// TIMED							
//============================================================================
#define __LIMITED_H __HEADER_ASP(timed/limited)
#define __DELAYED_H __HEADER_ASP(timed/delayed)
#include <timed.h>

__BEGIN_SYS

template<Aspect asp>
class Timed: public __INT(Timed) {};
template<>
class Timed<LIMITED>: public Limited {};
template<>
class Timed<DELAYED>: public Delayed {};

__END_SYS

//============================================================================
// ATOMIC							
//============================================================================
#define __UNINTERRUPTED_H __HEADER_ASP(atomic/uninterrupted)
#define __SYSTEM_LOCKED_H __HEADER_ASP(atomic/system)
#define __CLASS_LOCKED_H __HEADER_ASP(atomic/class)
#define __OBJECT_LOCKED_H __HEADER_ASP(atomic/object)
#include <atomic.h>

__BEGIN_SYS

template<Aspect asp>
class Atomic: public __INT(Atomic) {};
template<>
class Atomic<UNINTERRUPTED>: public Uninterrupted {};
template<>
class Atomic<SYSTEM_LOCKED>: public System_Locked {};
template<>
class Atomic<CLASS_LOCKED>: public Class_Locked {};
template<>
class Atomic<OBJECT_LOCKED>: public Object_Locked {};

__END_SYS

//============================================================================
// COMPRESSED							
//============================================================================
#define __LZWCOMPRESSED_H __HEADER_ASP(compressed/lzw)
#include <compressed.h>

__BEGIN_SYS

template<Aspect asp>
class Compressed: public __INT(Compressed) {};
template<>
class Compressed<LZW>: public LZW_Compressed {};

__END_SYS

#include __HEADER_FMK(individual/handle)

#endif
