#ifndef __mpi_h
#define __mpi_h

// #define MPI_DOUBLE          1
// #define MPI_INT             2
// #define MPI_BYTE            3
// #define MPI_FLOAT           4
#define MPI_DOUBLE          sizeof(double)
#define MPI_INT             sizeof(int)
#define MPI_BYTE            sizeof(char)
#define MPI_FLOAT           sizeof(float)

#define MPI_COMM_WORLD      0

#define MPI_MAX             1
#define MPI_SUM             2
#define MPI_MIN             3

#define MPI_SUCCESS         0
#define MPI_ANY_SOURCE     -1
#define MPI_ERR_OTHER      -1
#define MPI_ERR_COMM       -1
#define MPI_STATUS_SIZE     3

// MPI status
struct MPI_Status { 
    int count;
    int MPI_SOURCE;
    int MPI_TAG;
    int MPI_ERROR;
};

// MPI request
typedef int MPI_Request;

// MPI data type
typedef int MPI_Datatype;

// MPI communicator
typedef int MPI_Comm;

// MPI operation
typedef int MPI_Op;

// Prototypes

int MPI_Init(int * argc, char *** argv);
int MPI_Comm_rank(MPI_Comm comm,  int * rank);
int MPI_Comm_size(MPI_Comm comm,  int * size);
double MPI_Wtime(void);
int MPI_Irecv(void * buf, int count, MPI_Datatype datatype, int source, 
	      int tag, MPI_Comm comm, MPI_Request * request);
int MPI_Send(void * buf, int count, MPI_Datatype datatype, int dest, int tag,
	     MPI_Comm comm);
int MPI_Wait(MPI_Request * request, MPI_Status * status);
int MPI_Barrier(MPI_Comm comm);
int MPI_Finalize(void);
int MPI_Allreduce(void * sendbuf, void * recvbuf, int count,
		  MPI_Datatype type, MPI_Op op, MPI_Comm comm);
int MPI_Reduce(void * sendbuf,void * recvbuf,int nitems,MPI_Datatype type,
	       MPI_Op op,int root,MPI_Comm comm);
int MPI_Alltoall(void * sendbuf, int sendcount, MPI_Datatype sendtype,
		 void * recvbuf, int recvcount, MPI_Datatype recvtype,
		 MPI_Comm comm);
int MPI_Alltoallv(void * sendbuf, int * sendcounts, int * senddispl,
		  MPI_Datatype sendtype, void * recvbuf, int * recvcounts,
		  int * recvdispl, MPI_Datatype recvtype, MPI_Comm comm);

#endif
