#ifndef __network_h
#define __network_h

#include <config.h>

__BEGIN_SYS
__BEGIN_INT

class Network
{
public:
    Network();
    Network(const Id & id);
    Network(const Network & net);
    ~Network();

    const Id & id();
    bool valid();

    void send(const Node_Id & to, const void * buf,  unsigned int len);
    void receive(Node_Id * from, void * buf, unsigned int * len);
};

class Loop
{
public:
    Loop();
    Loop(const Id & id);
    Loop(const Loop & net);
    ~Loop();

    const Id & id();
    bool valid();

    void send(const Node_Id & to, const void * buf,  unsigned int len);
    void receive(Node_Id * from, void * buf, unsigned int * len);
};

class Ethernet
{
public:
    Ethernet();
    Ethernet(const Id & id);
    Ethernet(const Ethernet & net);
    ~Ethernet();

    const Id & id();
    bool valid();

    void send(const Node_Id & to, const void * buf,  unsigned int len);
    void receive(Node_Id * from, void * buf, unsigned int * len);
};

class Myrinet
{
public:
    Myrinet();
    Myrinet(const Id & id);
    Myrinet(const Myrinet & net);
    ~Myrinet();

    const Id & id();
    bool valid();

    void send(const Node_Id & to, const void * buf,  unsigned int len);
    void receive(Node_Id * from, void * buf, unsigned int * len);
};

__END_INT
__END_SYS

#ifdef __LOOP_H
#include __LOOP_H
#endif

#ifdef __ETHERNET_H
#include __ETHERNET_H
#endif

#ifdef __MYRINET_H
#include __MYRINET_H
#endif

#ifdef __FRAMEWORK_H
#include  __FRAMEWORK_H
#endif

#endif

