/*======================================================================*/
/* INTEL x86 INTERFACE							*/
/*                                                                      */
/* Author: Guto								*/
/*======================================================================*/
#ifndef pc_ix86_h
#define pc_ix86_h 1

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

/*======================================================================*/
/* CONSTANTS								*/
/*======================================================================*/
/* The PAGE/FRAME size in bytes */
#define IX86_PAGE_SIZE		4096

/* CPU FLAGS (register eflags) */
#define IX86_FLAG_CF		0x00000001
#define IX86_FLAG_ONE2		0x00000002
#define IX86_FLAG_PF		0x00000004
#define IX86_FLAG_ZERO3		0x00000008
#define IX86_FLAG_AF		0x00000010
#define IX86_FLAG_ZERO5		0x00000020
#define IX86_FLAG_ZF		0x00000040
#define IX86_FLAG_SF		0x00000080
#define IX86_FLAG_TF		0x00000100
#define IX86_FLAG_IF		0x00000200
#define IX86_FLAG_DF		0x00000400
#define IX86_FLAG_OF		0x00000800
#define IX86_FLAG_IOPL1		0x00001000
#define IX86_FLAG_IOPL2		0x00002000
#define IX86_FLAG_NT		0x00004000
#define IX86_FLAG_ZERO15	0x00008000
#define IX86_FLAG_RF		0x00010000
#define IX86_FLAG_VM		0x00020000
#define IX86_FLAG_AC		0x00040000
#define IX86_FLAG_VIF		0x00080000
#define IX86_FLAG_VIP		0x00100000
#define IX86_FLAG_ID		0x00200000
#define IX86_FLAG_ZERO22	0x00400000
#define IX86_FLAG_ZERO23	0x00800000
#define IX86_FLAG_ZERO24	0x01000000
#define IX86_FLAG_ZERO25	0x02000000
#define IX86_FLAG_ZERO26	0x04000000
#define IX86_FLAG_ZERO27	0x08000000
#define IX86_FLAG_ZERO28	0x10000000
#define IX86_FLAG_ZERO29	0x20000000
#define IX86_FLAG_ZERO30	0x40000000
#define IX86_FLAG_ZERO31	0x80000000

/* CRO FLAGS */
#define IX86_CR0_PE		0x00000001
#define IX86_CR0_MP		0x00000002
#define IX86_CR0_EM		0x00000004
#define IX86_CR0_TS		0x00000008
#define IX86_CR0_ET		0x00000010
#define IX86_CR0_NE		0x00000020
#define IX86_CR0_ZERO6		0x00000040
#define IX86_CR0_ZERO7		0x00000080
#define IX86_CR0_ZERO8		0x00000100
#define IX86_CR0_ZERO9		0x00000200
#define IX86_CR0_ZERO10		0x00000400
#define IX86_CR0_ZERO11		0x00000800
#define IX86_CR0_ZERO12		0x00001000
#define IX86_CR0_ZERO13		0x00002000
#define IX86_CR0_ZERO14		0x00004000
#define IX86_CR0_ZERO15		0x00008000
#define IX86_CR0_WP		0x00010000
#define IX86_CR0_ZERO17		0x00020000
#define IX86_CR0_AM		0x00040000
#define IX86_CR0_ZERO19		0x00080000
#define IX86_CR0_ZERO20		0x00100000
#define IX86_CR0_ZERO21		0x00200000
#define IX86_CR0_ZERO22		0x00400000
#define IX86_CR0_ZERO23		0x00800000
#define IX86_CR0_ZERO24		0x01000000
#define IX86_CR0_ZERO25		0x02000000
#define IX86_CR0_ZERO26		0x04000000
#define IX86_CR0_ZERO27		0x08000000
#define IX86_CR0_ZERO28		0x10000000
#define IX86_CR0_NW		0x20000000
#define IX86_CR0_CD		0x40000000
#define IX86_CR0_PG		0x80000000

/* SEGMENT DESCRIPTOR FLAGS */
#define IX86_SEG_ACC		0x01
#define IX86_SEG_RW		0x02
#define IX86_SEG_CONF		0x04
#define IX86_SEG_CODE		0x08
#define IX86_SEG_NOSYS	 	0x10
#define IX86_SEG_DPL1		0x20
#define IX86_SEG_DPL2		0x40
#define IX86_SEG_PRE		0x80
#define IX86_SEG_TSS		0x09
#define IX86_SEG_INT		0x0e
#define IX86_SEG_TRAP		0x0f
#define IX86_SEG_32		0x40
#define IX86_SEG_4K		0x80

/* PAGE_FLAGS */
#define IX86_PAGE_PRE		0x01
#define IX86_PAGE_RW      	0x02
#define IX86_PAGE_USR		0x04
#define IX86_PAGE_PWT		0x08
#define IX86_PAGE_PCD		0x10
#define IX86_PAGE_ACC		0x20
#define IX86_PAGE_DRT		0x40

/* IDT */
#define IX86_IDT_SIZE		256

/* EXCEPTIONS */
#define IX86_EXC_DIV0		0x00
#define IX86_EXC_DEBUG		0x01
#define IX86_EXC_NMI		0x02
#define IX86_EXC_BP		0x03
#define IX86_EXC_OVFLOW		0x04
#define IX86_EXC_BOUND		0x05
#define IX86_EXC_INVOP		0x06
#define IX86_EXC_NODEV		0x07
#define IX86_EXC_DOUBLE		0x08
#define IX86_EXC_FPU_OR		0x09
#define IX86_EXC_INVTSS		0x0a
#define IX86_EXC_NOTPRE		0x0b
#define IX86_EXC_STACK		0x0c
#define IX86_EXC_GPF		0x0d
#define IX86_EXC_PF		0x0e
#define IX86_EXC_RESERV		0x0f
#define IX86_EXC_FPU		0x10
#define IX86_EXC_ALIGN		0x11
#define IX86_EXC_BUS		0x12
#define IX86_EXC_LAST		0x1f

/*======================================================================*/
/* TYPES								*/
/*======================================================================*/
/* A 8 bits register */
typedef unsigned char Ix86_Reg8;

/* A 16 bits register */
typedef unsigned short Ix86_Reg16;

/* A 32 bits register */
typedef unsigned long Ix86_Reg32;

/* A 64 bits register */
typedef unsigned long long Ix86_Reg64;

/* A physical address */
typedef unsigned long Ix86_Phy_Addr;

/* A logical address (actually should be selector + offset or 48 Bits */
typedef unsigned long Ix86_Log_Addr;

/* A memory frame/page */
typedef unsigned char Ix86_Page[IX86_PAGE_SIZE];

/* A page table entry */
typedef Ix86_Phy_Addr Ix86_PTE;

/* A page directory entry */
typedef Ix86_Phy_Addr Ix86_PDE;

/* A page table */
typedef Ix86_PTE Ix86_PT[sizeof(Ix86_Page)/sizeof(Ix86_PTE)];

/* A page directory */
typedef Ix86_PTE Ix86_PD[sizeof(Ix86_Page)/sizeof(Ix86_PDE)];

/* A descriptor in GDT */
typedef struct
{
  Ix86_Reg16 limit_15_00;
  Ix86_Reg16 base_15_00;
  Ix86_Reg8  base_23_16;
  Ix86_Reg8  p_dpl_s_type;
  Ix86_Reg8  g_d_0_a_limit_19_16;
  Ix86_Reg8  base_31_24;
} Ix86_GDT_Desc;

/* A descriptor in IDT */
typedef struct
{
  Ix86_Reg16 offset_15_00;
  Ix86_Reg16 selector;
  Ix86_Reg8  zero;
  Ix86_Reg8  p_dpl_0_d_1_1_0;
  Ix86_Reg16 offset_31_16;
} Ix86_IDT_Desc;

/* A TSS */
typedef struct
{
  Ix86_Reg16 back_link;
  Ix86_Reg16 zero1;
  Ix86_Reg32 esp0;
  Ix86_Reg16 ss0;
  Ix86_Reg16 zero2;
  Ix86_Reg32 esp1;
  Ix86_Reg16 ss1;
  Ix86_Reg16 zero3;
  Ix86_Reg32 esp2;
  Ix86_Reg16 ss2;
  Ix86_Reg16 zero4;
  Ix86_Reg32 pdbr;
  Ix86_Reg32 eip;
  Ix86_Reg32 eflags;
  Ix86_Reg32 eax;
  Ix86_Reg32 ecx;
  Ix86_Reg32 edx;
  Ix86_Reg32 ebx;
  Ix86_Reg32 esp;
  Ix86_Reg32 ebp;
  Ix86_Reg32 esi;
  Ix86_Reg32 edi;
  Ix86_Reg16 es;
  Ix86_Reg16 zero5;
  Ix86_Reg16 cs;
  Ix86_Reg16 zero6;
  Ix86_Reg16 ss;
  Ix86_Reg16 zero7;
  Ix86_Reg16 ds;
  Ix86_Reg16 zero8;
  Ix86_Reg16 fs;
  Ix86_Reg16 zero9;
  Ix86_Reg16 gs;
  Ix86_Reg16 zero10;
  Ix86_Reg16 ldt;
  Ix86_Reg16 zero11;
  Ix86_Reg16 zero12;
  Ix86_Reg16 io_bmp;
} Ix86_TSS;

/*======================================================================*/
/* PROTOTYPES                                                           */
/*======================================================================*/
void          ix86_sti(void);
void          ix86_set_tr(Ix86_Reg16 tr);
Ix86_Reg16    ix86_get_tr(void);
void          ix86_set_cr0(Ix86_Reg32 cr0);
Ix86_Reg32    ix86_get_cr0(void);
Ix86_Reg32    ix86_get_cr2(void);
void          ix86_set_cr3(Ix86_Reg32 cr3);
Ix86_Reg32    ix86_get_cr3(void);
void          ix86_set_gdtr(Ix86_Reg16 limit, Ix86_Reg32 base);
void          ix86_get_gdtr(Ix86_Reg16 *limit, Ix86_Reg32 *base);
void          ix86_set_idtr(Ix86_Reg16 limit, Ix86_Reg32 base);
void          ix86_get_idtr(Ix86_Reg16 *limit, Ix86_Reg32 *base);
void          ix86_set_eflags(Ix86_Reg32 eflags);
Ix86_Reg32    ix86_get_eflags(void);
Ix86_Reg64    ix86_get_tsc(void);
Ix86_Reg8     ix86_inb(Ix86_Reg16 port);
void          ix86_outb(Ix86_Reg16 port, Ix86_Reg8 value);
Ix86_Reg16    ix86_inw(Ix86_Reg16 port);
void          ix86_outw(Ix86_Reg16 port, Ix86_Reg16 value);
void          ix86_invlpg(Ix86_Log_Addr log_addr);
void          ix86_flush_tlb(void);
void          ix86_set_gdt_entry(Ix86_GDT_Desc *gdt, int index,
				 Ix86_Reg32 base, Ix86_Reg32 limit,
				 Ix86_Reg8 flags);
void          ix86_set_idt_entry(Ix86_IDT_Desc *idt, int index,
				 Ix86_Reg16 selector, Ix86_Reg32 offset,
				 Ix86_Reg16 flags);
void          ix86_switch_tss(Ix86_Reg32 tss_selector);
void          ix86_push_all(void);
void          ix86_pop_all(void);
void          ix86_init_fpu(void);
Ix86_Reg32    ix86_get_page(Ix86_Log_Addr addr);
Ix86_Reg32    ix86_get_dir(Ix86_Log_Addr addr);
Ix86_Reg16    ix86_adjust_selector(Ix86_Reg16 selector, int rpl);
Ix86_Log_Addr ix86_align_page(Ix86_Log_Addr addr);
Ix86_Log_Addr ix86_align_dir(Ix86_Log_Addr addr);
Ix86_Reg16    ix86_htons(Ix86_Reg16);
Ix86_Reg32    ix86_htonl(Ix86_Reg32);

/*======================================================================*/
/* MACROS	                                                        */
/*======================================================================*/
#define ix86_get_page(A)          (((A) >> 12) & 0x03ff)
#define ix86_get_dir(A)           ((A) >> 22)
#define ix86_adjust_selector(S,R) (((S) << 3) | (R))
#define ix86_align_page(A)        (((A) + 0x0fff) & 0xfffff000)
#define ix86_align_dir(A)         (((A) + 0x00ffffff) & 0xff000000)
#define ix86_htons(V)		  (((V << 8) & 0xFF00) | ((V >> 8) & 0x00FF))
#define ix86_htonl(V)		  (((V << 24) & 0xFF000000) | \
	                           ((V <<  8) & 0x00FF0000) | \
	                      	   ((V >>  8) & 0x0000FF00) | \
	                      	   ((V >> 24) & 0x000000FF))
 
#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* pc_ix86_h */
