#ifndef __segment_h
#define __segment_h

#include <config.h>

__BEGIN_SYS
__BEGIN_INT

class Segment
{
public:
    Segment();
    Segment(const Id & id);
    Segment(const Segment & seg);
    ~Segment();

    const Id & id();
    bool valid();

    // methods
};

class Static_Segment
{
public:
    Static_Segment();
    Static_Segment(const Id & id);
    Static_Segment(const Static_Segment & seg);
    ~Static_Segment();

    const Id & id();
    bool valid();

    // methods
};

class Dynamic_Segment
{
public:
    Dynamic_Segment();
    Dynamic_Segment(const Id & id);
    Dynamic_Segment(const Dynamic_Segment & seg);
    ~Dynamic_Segment();

    const Id & id();
    bool valid();

    // methods
};

__END_INT
__END_SYS

#ifdef __STATIC_SEGMENT_H
#include __STATIC_SEGMENT_H
#endif

#ifdef __DYNAMIC_SEGMENT_H
#include __DYNAMIC_SEGMENT_H
#endif

#ifdef __FRAMEWORK_H
#include  __FRAMEWORK_H
#endif

#endif

