#ifndef __synchronizer_h
#define __synchronizer_h

#include <config.h>

__BEGIN_SYS
__BEGIN_INT

class Synchronizer
{
public:
    Synchronizer(int value = 1);
    Synchronizer(const Id & id);
    Synchronizer(const Synchronizer & sync);
    ~Synchronizer();

    const Id & id();
    bool valid();

    void lock();
    void unlock();

    void p();
    void v();

    void wait();
    void signal();
    void broadcast();
};

class Mutex
{
public:
    Mutex();
    Mutex(const Id & id);
    Mutex(const Mutex & sync);
    ~Mutex();

    const Id & id();
    bool valid();

    // methods
};

class Semaphore
{
public:
    Semaphore();
    Semaphore(const Id & id);
    Semaphore(const Semaphore & sync);
    ~Semaphore();

    const Id & id();
    bool valid();

    void p();
    void v();
};

class Condition
{
public:
    Condition();
    Condition(const Id & id);
    Condition(const Condition & sync);
    ~Condition();

    const Id & id();
    bool valid();

    void lock();
    void unlock();
    void wait();
    void signal();
    void broadcast();
};

__END_INT
__END_SYS

#ifdef __MUTEX_H
#include __MUTEX_H
#endif

#ifdef __SEMAPHORE_H
#include __SEMAPHORE_H
#endif

#ifdef __CONDITION_H
#include __CONDITION_H
#endif

#ifdef __FRAMEWORK_H
#include  __FRAMEWORK_H
#endif

#endif

