#ifndef __typed_envelope_h
#define __typed_envelope_h

#include "untyped.h"

__BEGIN_SYS
__BEGIN_IMP

class Typed_Envelope: public Untyped_Envelope
{
    typedef Traits<Typed_Envelope> traits;

public:
    Typed_Envelope(const Id & r, unsigned int l)
	: Untyped_Envelope(r, l) {}
    Typed_Envelope(const Id & r, unsigned int l, void * b)
	: Untyped_Envelope(r, l, b) {}

    static int init(System_Info * si);

private:
    void pack(const void *p, unsigned int l) {
	if((_length + l) <= _max_length) {
	    memcpy(_ptr, p, l);
	    _ptr += l;
	    _length += l;
	}
    }
};

__END_IMP
__END_SYS

#endif

