#ifndef __untyped_envelope_h
#define __untyped_envelope_h

#include <envelope.h>
#include "common.h"

__BEGIN_SYS
__BEGIN_IMP

class Untyped_Envelope: protected Envelope_Common
{
    typedef Traits<Untyped_Envelope> traits;

public:
    Untyped_Envelope(const Id & recipient, unsigned int length);
    Untyped_Envelope(const Id & recipient, unsigned int length, void * buffer);
    ~Untyped_Envelope();

    void * buffer() { return _buffer; };

    static int init(System_Info *si);

private:
    void pack(const void *p, unsigned int l) {
	if((_length + l) <= _max_length) {
	    memcpy(_ptr, p, l);
	    _ptr += l;
	    _length += l;
	}
    }
	
protected:
    char * _buffer;
    char * _ptr;
    unsigned int _max_length;
};

__END_IMP
__END_SYS

#endif

