#ifndef __loop_h
#define __loop_h

#include <network.h>
#include "common.h"

__BEGIN_SYS
__BEGIN_IMP

class Loop: private Network_Common
{
    typedef Traits<Loop> traits;

    static const Type_Id type = traits::type;
    static const unsigned int _mtu = 65536;

public:
    Loop();
    ~Loop();

    int send(const Node_Id & r, const void * b, unsigned int l);
    int receive(Node_Id * s, void * b, unsigned int * l);

    static unsigned int mtu() { return _mtu; }

    static int init(System_Info *si);

private:
    Node_Id id;
    unsigned int length;
    char buffer[_mtu];
    bool full;
};

__END_IMP
__END_SYS

#endif

