#ifndef __myrinet_h
#define __myrinet_h

#include <network.h>
#include "common.h"

__BEGIN_SYS
__BEGIN_IMP

class Myrinet: private Network_Common
{
    typedef Traits<Myrinet> traits;

    static const Type_Id type = traits::type;
    static const unsigned int _alen = 8;
    static const unsigned int _mtu = 0;

    typedef unsigned char Address[_alen];

    struct Header {
    };

    struct Frame {
	Header header;
	unsigned char payload[1];
    };

public:
    Myrinet();
    ~Myrinet();

    int send(const Node_Id & r, const void * b, unsigned int l);
    int receive(Node_Id * s, void * b, unsigned int * l); 

    static unsigned int mtu() { return _mtu; }

    static int init(System_Info * si);

protected:
    // data
};

__END_IMP
__END_SYS

#endif

