#ifndef __mutex_h
#define __mutex_h

#include <synchronizer.h>
#include "common.h"
#include <pthread.h>

__BEGIN_SYS
__BEGIN_IMP

class Mutex: private Synchronizer_Common
{
    typedef Traits<Mutex> traits;

    static const Type_Id type = traits::type;

public:
    Mutex();
    ~Mutex();

    void lock();
    void unlock();

    static int init(System_Info * si);

protected:
    pthread_mutex_t mutex;
};

__END_IMP
__END_SYS

#endif

