#ifndef __semaphore_h
#define __semaphore_h

#include <synchronizer.h>
#include "common.h"
#include <semaphore.h>

__BEGIN_SYS
__BEGIN_IMP

class Semaphore: private Synchronizer_Common
{
    typedef Traits<Semaphore> traits;

    static const Type_Id type = traits::type;

public:
    Semaphore(int value = 1);
    ~Semaphore();

    void p();
    void v();

    static int init(System_Info * si);

protected:
    sem_t sem;
};

__END_IMP
__END_SYS

#endif

