#ifndef __alarm_h
#define __alarm_h

#include <timer.h>
#include "common.h"

__BEGIN_SYS
__BEGIN_IMP

class Alarm: private Timer_Common
{
public:
    Alarm();
    ~Alarm();

    const Time & resolution() { return _resolution; }
    void delay(const Time & seconds);
    void delay(const Tick & ticks);
    void alarm(const Time & seconds,  void (* handler )(void),
	       unsigned int count = 1);
    void alarm(const Tick & ticks, void (* handler )(void),
	       unsigned int count = 1);

    static int init(System_Info * si);

protected:
    static Time _resolution;
};

__END_IMP
__END_SYS

#endif

