#ifndef __local_id_h
#define __local_id_h

#include <id.h>
#include <system/debugger.h>
#include "common.h"

__BEGIN_SYS

class Local_Id: private Id_Common
{
public:
    Local_Id(const Type_Id & t, const Unit & u): _type(t), _unit(u) {}
    Local_Id(const Local_Id & i) { *this = i; }

    const Local_Id & id() const { return *this; }
    bool valid() const { return (_unit != ANY_UNIT); }
    const Type_Id & type() const { return _type; }
    const Unit & unit() const { return _unit; }

    friend Debugger & operator << (Debugger & db, const Local_Id & id)
	{ db << "[t=" << id.type() << ",u=" << id.unit() << "]" ; return db; }

protected:
    Local_Id() { dbwrn << "Warning: empty id!\n"; } // for new Scenario

    void id(const Type_Id & t, const Unit & u) { _type = t; _unit = u; }

private:
    Type_Id _type;
    Unit _unit;
};

__END_SYS

#endif

