#ifndef __debugger_h
#define __debugger_h 

#include <config.h>

#ifdef DEBUG

#include <iostream>

__BEGIN_SYS

class Debugger
{
public:
    Debugger & operator () (int t) { type = t; return *this; }
    Debugger & operator << (const void *p) { std::cerr << p; return *this; }
    Debugger & operator << (const char *s) { std::cerr << s; return *this; }
    Debugger & operator << (int i) { std::cerr << i; return *this; }

private:
    int type;
}; 

__END_SYS

#else

__BEGIN_SYS

class Debugger
{
public:
    Debugger & operator () (int t) { return *this; }
    Debugger & operator << (const void * p) { return *this; }
    Debugger & operator << (const char * s) { return *this; }
    Debugger & operator << (int i) { return *this; }
};

__END_SYS

#endif

__BEGIN_SYS

extern Debugger dbtrc, dberr, dbwrn, dbinf;

__END_SYS

#endif

