#ifndef __scenario_h
#define __scenario_h

#include <id.h>
#include <shared.h>
#include <allocated.h>
#include <timed.h>
#include <atomic.h>
#include <debugged.h>

__BEGIN_SYS

template<class Imp>
class Scenario: public Id,
		private Shared<Traits<Imp>::shared>,
		private Allocated<Traits<Imp>::allocated>,
		private Protected<Traits<Imp>::protect>,
		private Timed<Traits<Imp>::timed>,
		private Atomic<Traits<Imp>::atomic>
		private Compressed<Traits<Imp>::compressed>
{
protected:
  static Adapter<Imp>* alloc()
    { return (Adapter<Imp>*)::operator new(sizeof(Adapter<Imp>)); }

  static Adapter<Imp>* get(const Id & id)
    { return alloc(); }

  static Adapter<Imp>* share(const Id & id)
    { return alloc(); }

  static Adapter<Imp>* share(Adapter<Imp>* adapter)
    { return adapter; }

  static void free(Adapter<Imp>* obj)
    { delete obj; }

  void enter() {
    lock();
  }

  void leave() {
    unlock();
  }

  static void static_enter() {
    static_lock();
  }

  static void static_leave() {
    static_unlock();
  }
};

__END_SYS

#endif
