/*======================================================================*/
/* INTERFACE FOR A SIMPLE OS LEVEL PRINTF                               */
/*                                                                      */
/* Auth: Guto                                                           */
/*======================================================================*/
#ifndef kprintf_h
#define kprintf_h 1

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

/*======================================================================*/
/* DEPENDENCIES                                                         */
/*======================================================================*/
/* #include <pc/cga.h> */

/*======================================================================*/
/* PROTOTYPES                                                           */
/*======================================================================*/
void kprintf(const char *fmt, ...);
void ksprintf(char *str, const char *fmt, ...);

int  dtoa(int d, char *str);
int  utoa(unsigned int u, char *str);
int  xtoa(unsigned int x, char *str);
int  ptoa(void *p, char *str);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* kprintf_h */
