/*======================================================================*/
/* SYSTEM MEMORY MAP							*/
/*                                                                      */
/* Auth: Guto								*/
/*======================================================================*/
#ifndef mem_map_h
#define mem_map_h 1

/*======================================================================*/
/* CONSTANTS			                                      	*/
/*======================================================================*/
/* PHYSICAL MEMORY MAP */
#define CGA_FBUF_PHY_ADDR	0x000b8000 /* The CGA frame buffer */
#define BOOT_IMAGE_PHY_ADDR	0x00008000 /* The boot strap will laod the */
                                           /* image to this address */

/* LOGICAL MEMORY MAP (logical address space of any task) */
/* 0x0000 0000 -+-----------------------+ APP_LOG_ADDR		*/
/*		| APP (2G)		|			*/
/*		:			:			*/
/*		|			|			*/
/* 0x8000 0000 -+-----------------------+ PHY_MEM_LOG_ADDR	*/
/*		| PHY MEM (1G)		|			*/
/*		:			:			*/
/*		|			|			*/
/* 0xc000 0000 -+-----------------------+ COPY_AREA_LOG_ADDR	*/
/*		| COPY AREA (256M)	|			*/
/*		: 			:			*/
/*		|			|			*/
/* 0xd000 0000 -+-----------------------+ PCI_MEM_LOG_ADDR	*/
/*		| PCI MEM (256M)	|			*/
/*		: 			:			*/
/*		|			|			*/
/* 0xe000 0000 -+-----------------------+ 			*/
/*		| RESERVED (508M)	|			*/
/*		: 			:			*/
/*		|			|			*/
/* 0xffc0 0000 -+-----------------------+ IDT_LOG_ADDR		*/
/*		| IDT (4K)		|			*/
/* 0xffc0 1000 -+-----------------------+ GDT_LOG_ADDR		*/
/*		| GDT (4K)		|			*/
/* 0xffc0 2000 -+-----------------------+ SYS_PT_LOG_ADDR	*/
/*		| SYS_PT (4K)		|			*/
/* 0xffc0 3000 -+-----------------------+ SYS_PD_LOG_ADDR	*/
/*		| SYS_PD (4K)		|			*/
/* 0xffc0 4000 -+-----------------------+ SYS_INFO_LOG_ADDR	*/
/*		| SYS_INFO (4K)		|			*/
/* 0xffc0 5000 -+-----------------------+ 			*/
/*		| RESERVED (1M - 20K)	|			*/
/*		: 			:			*/
/*		|			|			*/
/* 0xffd0 0000 -+-----------------------+ THREAD_TAB_LOG_ADDR	*/
/*		| THREAD TAB (4K * 256)	|			*/
/*		: 			:			*/
/*		|			|			*/
/* 0xffe0 0000 -+-----------------------+ AS_TAB_LOG_ADDR	*/
/*		| AS TAB (4K * 256)	|			*/
/*		: 			:			*/
/*		|			|			*/
/* 0xfff0 0000 -+-----------------------+ SYS_CODE_LOG_ADDR	*/
/*		| SYS CODE (256K)	|			*/
/*		: 			:			*/
/*		|			|			*/
/* 0xfff4 0000 -+-----------------------+ SYS_CODE_LOG_ADDR	*/
/*		| SYS DATA (512K)	|			*/
/*		: 			:			*/
/*		|			|			*/
/* 0xfffc 0000 -+-----------------------+ SYS_DATA_LOG_ADDR	*/
/*		| RESERVED (252K)	|			*/
/*		: 			:			*/
/*		|			|			*/
/* 0xffff f000 -+-----------------------+ SYS_STACK_LOG_ADDR	*/
/*		| SYS STACK (4K)	|			*/
/* 0xffff ffff -+-----------------------+ 			*/

						/* begin	size	  */
#define APP_LOG_ADDR		0x00000000	/* 0		2 G	  */
#define PHY_MEM_LOG_ADDR	0x80000000	/* 2 G		1 G	  */
#define COPY_AREA_LOG_ADDR	0xc0000000	/* 3 G		256 M	  */
#define PCI_MEM_LOG_ADDR	0xd0000000	/* + 256 M	256 M	  */
/* RESERVED			0xd0000000	   + 512 M	508 M	  */ 
#define IDT_LOG_ADDR		0xffc00000	/* 4 G - 4 M	4 K	  */
#define GDT_LOG_ADDR		0xffc01000	/* + 4 K	4 K	  */
#define SYS_PT_LOG_ADDR		0xffc02000	/* + 8 K	4 K	  */
#define SYS_PD_LOG_ADDR		0xffc03000	/* + 12 K	4 K	  */
#define SYS_INFO_LOG_ADDR	0xffc04000	/* + 16 K	4 K	  */
/* RESERVED			0xffc05000	   + 20 K	1 M - 20K */ 
#define THREAD_TAB_LOG_ADDR	0xffd00000	/* 4 G - 3 M	4 K * 256 */
#define AS_TAB_LOG_ADDR		0xffe00000	/* 4 G - 2 M	4 K * 256 */
#define SYS_CODE_LOG_ADDR	0xfff00000	/* 4 G - 1 M	256 K	  */
#define SYS_DATA_LOG_ADDR	0xfff40000	/* + 256 K	512 K	  */
/* RESERVED			0xfffc0000	   + 768 K	252 K	  */ 
#define SYS_STACK_LOG_ADDR	0xfffff000	/* 4 G - 4 K	4 K	  */
#define CGA_FBUF_LOG_ADDR	0x800b8000

#endif /* mem_map_h */
