/*======================================================================*/
/* NODE SETUP INTERFACE  		                                */
/*                                                                      */
/* Auth: Guto								*/
/*======================================================================*/
#ifndef setup_h
#define setup_h 1

/*======================================================================*/
/* DEPENDENCIES                                                         */
/*======================================================================*/
/* #include <pc/ix86.h> */
#include <system/memory_map.h>
#include <system/info.h>

/*======================================================================*/
/* CONSTANTS                                                            */
/*======================================================================*/
/* Mask to clear (by ANDing) AC, VM, RF, NT, IOPL and TF CPU flags */
#define EFLAGS_MASK \
	(~( IX86_FLAG_TF	| IX86_FLAG_IOPL1	| IX86_FLAG_IOPL2 \
	  | IX86_FLAG_NT	| IX86_FLAG_RF		| IX86_FLAG_VM	\
	  | IX86_FLAG_AC ))

/* Mask to clear (by ANDing) CD, NW, AM, NE, TS and EM flags from CR 0 */
#define CR0_CLEAR_MASK		0x9ffbffd3

/* Mask to set (by ORing) PG, ET, MP and PE flags from CR 0 */
#define CR0_SET_MASK		0x80000013

/* SEGMENT FLAGS MASKS */
/* Mask to set (by ORing) P, DPL=3, S, C, W and A in a segment descriptor */
#define SEG_FLAGS_APP_CODE \
	( IX86_SEG_PRE		\
	| IX86_SEG_NOSYS	| IX86_SEG_CODE	       	| IX86_SEG_ACC )
/* 	( IX86_SEG_PRE		| IX86_SEG_DPL2		| IX86_SEG_DPL1	\
 	| IX86_SEG_NOSYS	| IX86_SEG_CODE	       	| IX86_SEG_ACC ) */
/* Mask to set (by ORing) P, DPL=3, S, W and A in a segment descriptor */
#define SEG_FLAGS_APP_DATA \
	( IX86_SEG_PRE		\
	| IX86_SEG_NOSYS	| IX86_SEG_RW   	| IX86_SEG_ACC )
/*	( IX86_SEG_PRE		| IX86_SEG_DPL2		| IX86_SEG_DPL1	\
	| IX86_SEG_NOSYS	| IX86_SEG_RW   	| IX86_SEG_ACC ) */
/* Mask to set (by ORing) P, DPL=0, S, C, W and A in a segment descriptor */
#define SEG_FLAGS_SYS_CODE \
      	( IX86_SEG_PRE		| IX86_SEG_NOSYS	| IX86_SEG_CODE	\
	| IX86_SEG_ACC )
/* Mask to set (by ORing) P, DPL=0, S, W and A in a segment descriptor */
#define SEG_FLAGS_SYS_DATA \
	( IX86_SEG_PRE		| IX86_SEG_NOSYS	| IX86_SEG_RW	\
	| IX86_SEG_ACC )
/* Mask to set (by ORing) P, DPL=0 and TYPE=TSS in a segmend descriptor */
#define SEG_FLAGS_TSS \
	( IX86_SEG_PRE	 	| IX86_SEG_TSS )
/* Mask to set (by ORing) P, DPL=0 and TYPE=INT_GATE in a segmend descriptor */
#define SEG_FLAGS_INT \
	( IX86_SEG_PRE	 	| IX86_SEG_INT )

/* PAGE FLAGS MASKS */
/* Mask to set (by ORing) P, W and A in a page */
#define PAGE_FLAGS_SYS ( IX86_PAGE_PRE	| IX86_PAGE_RW	| IX86_PAGE_USR \
		       | IX86_PAGE_ACC )
/* Mask to set (by ORing) P, W, U, A and PCD in a page */
#define PAGE_FLAGS_PCI ( IX86_PAGE_PRE	| IX86_PAGE_RW	| IX86_PAGE_USR \
		       | IX86_PAGE_ACC 	| IX86_PAGE_PCD)
/* Mask to set (by ORing) P, W, U and A in a page */
#define PAGE_FLAGS_APP ( IX86_PAGE_PRE	| IX86_PAGE_RW	| IX86_PAGE_USR \
		       | IX86_PAGE_ACC )
/* #define PAGE_FLAGS_APP ( IX86_PAGE_PRE | IX86_PAGE_RW | IX86_PAGE_ACC ) */
 
/* GDT ORGANIZATION */
/* GDT_TSS denotes the first TSS. The number of TSS is configurable */
#define GDT_NULL		0
#define GDT_APP_CODE       	1
#define GDT_APP_DATA       	2
#define GDT_APP_STACK		3	/* not used at present versions */   
#define GDT_SYS_CODE		4
#define GDT_SYS_DATA		5
#define GDT_SYS_STACK		6	/* not used at present versions */   
#define GDT_TSS			16
#define GDT_LAST		511	/* our GDT is only 4K */

/* IDT ORGANIZATION */
#define IDT_HARD_INT		32      /* index in IDT where hardware */
                                        /* interrupts will be mapped */
#endif /* setup_h */
