#ifndef __task_h
#define __task_h

#include <config.h>

__BEGIN_SYS
__BEGIN_INT

class Task
{
public:
    Task();
    Task(const Id & id);
    Task(const Task & task);
    ~Task();

    const Id & id();
    bool valid();

    // methods
};

class Exclusive_Task
{
public:
    Exclusive_Task();
    Exclusive_Task(const Id & id);
    Exclusive_Task(const Exclusive_Task & task);
    ~Exclusive_Task();

    const Id & id();
    bool valid();

    // methods
};

class Mutual_Task
{
public:
    Mutual_Task();
    Mutual_Task(const Id & id);
    Mutual_Task(const Mutual_Task & task);
    ~Mutual_Task();

    const Id & id();
    bool valid();

    // methods
};

__END_INT
__END_SYS

#ifdef __EXCLUSIVE_TASK_H
#include __EXCLUSIVE_TASK_H
#endif

#ifdef __MUTUAL_TASK_H
#include __MUTUAL_TASK_H
#endif

#ifdef __FRAMEWORK_H
#include  __FRAMEWORK_H
#endif

#endif

