#ifndef __thread_h
#define __thread_h

#include <config.h>

__BEGIN_SYS

// States of a thread
enum Thread_State {
    RUNNING,
    READY,
    SUSPENDED
};

// Priorities of a thread
enum Thread_Priority {
    THREAD_HIGHEST_PRIORITY = 0,
    THREAD_NORMAL_PRIORITY = 15,
    THREAD_LOWEST_PRIORITY = 31
};


// Status of a thread
struct Thread_Status {
    Thread_State state;
    Thread_Priority priority;
};

// Thread self reference
enum Thread_Self {SELF};

__BEGIN_INT

class Thread
{
public:
    Thread(int (* const entry)(int), int arg = 0,
	   const Thread_State & state = READY);
    Thread(const Thread_Self &);
    Thread(const Id & id);
    Thread(const Thread & thread);
    ~Thread();

    const Id & id();
    bool valid();

    void stat(Thread_Status * status);
    void suspend();
    void resume();
    int join(int * exit_status);
    int pass();

    static void exit(int exit_status = 0);
    static int yield();
};

class Exclusive_Thread
{
public:
    Exclusive_Thread(const Thread_Self &);
    Exclusive_Thread(const Id & id);
    Exclusive_Thread(const Exclusive_Thread & thread);
    ~Exclusive_Thread();

    const Id & id();
    bool valid();

    void stat(Thread_Status * status);

    static void exit(int exit_status = 0);
};

class Cooperative_Thread
{
public:
    Cooperative_Thread(int (* const entry)(int), int arg = 0,
		       const Thread_State & state = READY);
    Cooperative_Thread(const Thread_Self &);
    Cooperative_Thread(const Id & id);
    Cooperative_Thread(const Cooperative_Thread & thread);
    ~Cooperative_Thread();

    const Id & id();
    bool valid();

    void stat(Thread_Status * status);
    void suspend();
    void resume();
    int join(int * exit_status);
    int pass();

    static void exit(int exit_status = 0);
};

class Concurrent_Thread
{
public:
    Concurrent_Thread(int (* const entry)(int), int arg = 0,
		      const Thread_State & state = READY);
    Concurrent_Thread(const Thread_Self &);
    Concurrent_Thread(const Id & id);
    Concurrent_Thread(const Concurrent_Thread & thread);
    ~Concurrent_Thread();

    const Id & id();
    bool valid();

    void stat(Thread_Status * status);
    void suspend();
    void resume();
    int join(int * exit_status);
    int pass();

    static void exit(int exit_status = 0);
    static int yield();
};

__END_INT
__END_SYS

#ifdef __EXCLUSIVE_THREAD_H
#include __EXCLUSIVE_THREAD_H
#endif

#ifdef __COOPERATIVE_THREAD_H
#include __COOPERATIVE_THREAD_H
#endif

#ifdef __CONCURRENT_THREAD_H
#include __CONCURRENT_THREAD_H
#endif

#ifdef __FRAMEWORK_H
#include  __FRAMEWORK_H
#endif

#endif

