#ifndef __timer_h
#define __timer_h

#include <config.h>

__BEGIN_SYS

// A timer tick
typedef unsigned long long int Tick;

// The time (as defined by God Chronos, measured in seconds)
typedef double Time;

// An alarm handler
typedef void (* Alarm_Handler )();

__BEGIN_INT

class Timer
{
public:
    Timer();
    Timer(const Id & id);
    Timer(const Timer & timer);
    ~Timer();

    const Id & id();
    bool valid();

    const Time & resolution();

    Time now();
    Tick ticks();

    void delay(const Time & seconds);
    void delay(const Tick & ticks);
    void alarm(const Time & seconds,  void (* handler )(void),
	       unsigned int count = 1);
    void alarm(const Tick & ticks, void (* handler )(void),
	       unsigned int count = 1);

    void reset();
    void start();
    void lap();
    void stop();
    Time read();
};

class Clock
{
public:
    Clock();
    Clock(const Id & id);
    Clock(const Clock & clock);
    ~Clock();

    const Id & id();
    bool valid();

    const Time & resolution();
    Time now();
    Tick ticks();
};

class Alarm
{
public:
    Alarm();
    Alarm(const Id & id);
    Alarm(const Alarm & alarm);
    ~Alarm();

    const Id & id();
    bool valid();

    const Time & resolution();
    void delay(const Time & seconds);
    void delay(const Tick & ticks);
    void alarm(const Time & seconds,  void (* handler )(void),
	       unsigned int count = 1);
    void alarm(const Tick & ticks, void (* handler )(void),
	       unsigned int count = 1);
};

class Chronometer
{
public:
    Chronometer();
    Chronometer(const Id & id);
    Chronometer(const Chronometer & chronometer);
    ~Chronometer();

    const Id & id();
    bool valid();

    const Time & resolution();
    void reset();
    void start();
    void lap();
    void stop();
    Time read();
    Tick ticks();
};

__END_INT
__END_SYS

#ifdef __CLOCK_H
#include __CLOCK_H
#endif

#ifdef __ALARM_H
#include __ALARM_H
#endif

#ifdef __CHRONOMETER_H
#include __CHRONOMETER_H
#endif

#ifdef __FRAMEWORK_H
#include  __FRAMEWORK_H
#endif

#endif

