#ifndef __traits_h
#define __traits_h

#include <system/config.h>

__BEGIN_SYS

enum Aspect {
    FALSE = 0,
    POINTER_ID,
    LOCAL_ID,
    GLOBAL_ID,
    CAPABILITY,
    REFERENCED,
    ENROLLED,
    AHEAD,
    LATE,
    CHECKED,
    PERMITTED,
    LIMITED,
    DELAYED,
    UNINTERRUPTED,
    SYSTEM_LOCKED,
    CLASS_LOCKED,
    OBJECT_LOCKED,
    REMOTE,
    WATCHED,
    TRACED,
    PROFILED
};

template<class Imp>
struct Traits
{
    static const Aspect shared = FALSE;
    static const Aspect allocated = FALSE;
    static const Aspect atomic = FALSE;
#if #CONF_REMOTE (True)	
    static const Aspect remote = REMOTE;
#else
    static const Aspect remote = FALSE;
#endif
    static const Aspect timed = FALSE;
    static const Aspect debugged = FALSE;
    static const Aspect protect = FALSE;

private:
    static const Type_Id type = ANY_TYPE;
};

template<>
struct Traits<__IMP(Flat)>: public Traits<void> {
    static const Type_Id type = FLAT; 
};

template<>
struct Traits<__IMP(Paged)>: public Traits<void> {
    static const Type_Id type = PAGED; 
};

template<>
struct Traits<__IMP(Stream)>: public Traits<void> {
    static const Type_Id type = STREAM; 
};

template<>
struct Traits<__IMP(Datagram)>: public Traits<void> {
    static const Type_Id type = DATAGRAM; 
};

template<>
struct Traits<__IMP(AM)>: public Traits<void> {
    static const Type_Id type = ACTIVE; 
};

template<>
struct Traits<__IMP(Link)>: public Traits<void> {
    static const Type_Id type = LINK; 
};

template<>
struct Traits<__IMP(Port)>: public Traits<void> {
    static const Type_Id type = PORT; 
};

template<>
struct Traits<__IMP(Mailbox)>: public Traits<void> {
    static const Type_Id type = MAILBOX; 
};

template<>
struct Traits<__IMP(ARM_Segment)>: public Traits<void> {
    static const Type_Id type = ARM_SEGMENT; 
};

template<>
struct Traits<__IMP(AM_Handler)>: public Traits<void> {
    static const Type_Id type = AM_HANDLER; 
};

template<>
struct Traits<__IMP(Untyped_Envelope)>: public Traits<void> {
    static const Type_Id type = UNTYPED_ENVELOPE; 
};

template<>
struct Traits<__IMP(Typed_Envelope)>: public Traits<void> {
    static const Type_Id type = TYPED_ENVELOPE; 
};

template<>
struct Traits<__IMP(Function_Handler)>: public Traits<void> {
    static const Type_Id type = FUNCTION_HANDLER; 
};

template<>
struct Traits<__IMP(Thread_Handler)>: public Traits<void> {
    static const Type_Id type = THREAD_HANDLER; 
};

template<>
struct Traits<__IMP(Semaphore_Handler)>: public Traits<void> {
    static const Type_Id type = SEMAPHORE_HANDLER; 
};

template<>
struct Traits<__IMP(Loop)>: public Traits<void> {
    static const Type_Id type = LOOP; 
    static const unsigned int mtu = 65536;
};

template<>
struct Traits<__IMP(Ethernet)>: public Traits<void> {
    static const Type_Id type = ETHERNET; 
    static const unsigned short protocol = 0x8000;
    static const unsigned int max_peers = 8;
};

template<>
struct Traits<__IMP(Myrinet)>: public Traits<void> {
    static const Type_Id type = MYRINET; 
};

template<>
struct Traits<__IMP(Static_Segment)>: public Traits<void> {
    static const Type_Id type = STATIC_SEGMENT; 
};

template<>
struct Traits<__IMP(Dynamic_Segment)>: public Traits<void> {
    static const Type_Id type = DYNAMIC_SEGMENT; 
};

template<>
struct Traits<__IMP(Mutex)>: public Traits<void> {
    static const Type_Id type = MUTEX; 
};

template<>
struct Traits<__IMP(Semaphore)>: public Traits<void> {
    static const Type_Id type = SEMAPHORE; 
};

template<>
struct Traits<__IMP(Condition)>: public Traits<void> {
    static const Type_Id type = CONDITION; 
};

template<>
struct Traits<__IMP(Exclusive_Task)>: public Traits<void> {
    static const Type_Id type = EXCLUSIVE_TASK; 
};

template<>
struct Traits<__IMP(Mutual_Task)>: public Traits<void> {
    static const Type_Id type = MUTUAL_TASK; 
};

template<>
struct Traits<__IMP(Exclusive_Thread)>: public Traits<void> {
    static const Type_Id type = EXCLUSIVE_THREAD; 
};

template<>
struct Traits<__IMP(Cooperative_Thread)>: public Traits<void> {
    static const Type_Id type = COOPERATIVE_THREAD; 
};

template<>
struct Traits<__IMP(Concurrent_Thread)>: public Traits<void> {
    static const Type_Id type = CONCURRENT_THREAD; 
};

template<>
struct Traits<__IMP(Clock)>: public Traits<void> {
    static const Type_Id type = CLOCK; 
};
template<>
struct Traits<__IMP(Alarm)>: public Traits<void> {
    static const Type_Id type = ALARM; 
};
template<>
struct Traits<__IMP(Chronometer)>: public Traits<void> {
    static const Type_Id type = CHRONOMETER; 
};

__END_SYS

#endif
