#include <system/kprintf.h>

extern "C" {

  void *__eh_pc;
  void __throw() {kprintf("trow called!\n");};

  void exit(int status){for(;;);};

  void __builtin_delete (void *obj){kprintf("delete called!\n");};

  void * __builtin_new (int size) {
    const int buf_size = 4096;
    static char buffer[buf_size];
    static char *ptr = buffer;
    if((ptr + size) > (buffer + buf_size)) {
      kprintf("Heap overflow: new failed!\n");
      return 0;
    } else {
      char *tmp = ptr;
      ptr += size;
      return tmp;
    }
  }
}
//void terminate(void){};
