/*======================================================================*/
/* GUEST LEVEL IMPLEMENTATION FOR LINUX	                                */
/*                                                                      */
/* Auth: Guto                                                           */
/*======================================================================*/
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/mman.h>
#include <sys/ioctl.h>
#include <fcntl.h>

#include <system/debug.h>
#include <pc/pci.h>

void *io_bus_get_dev_mem(unsigned short dev_id, int unit)
{
  static char dev_name[] = "/dev/mlanaiX";
  int fd;
  unsigned long size;
  void *addr;

  switch(dev_id) {
  case PCI_DEV_ID_MYRINET:
    dev_name[11] = '0' + unit;
    fd = open(dev_name, O_RDWR);
    if(fd < 0) {
      debug(DB_WARNING, DB_GUEST, "can't open %s!\n", dev_name);
      return 0;
    }

    #define PCIMAP_GET_SIZE _IOC(_IOC_WRITE, 0, 1, 4)
    if(ioctl(fd, PCIMAP_GET_SIZE, &size) < 0) {
      debug(DB_WARNING, DB_GUEST, "can't get %s's size!\n", dev_name);
      return 0;
    }

    addr = mmap(0, size, PROT_READ | PROT_WRITE, MAP_SHARED, fd, 0);
    if(addr < 0) {
      debug(DB_WARNING, DB_GUEST, "can't map %s!\n", dev_name);
      return 0;
    }

    return addr;
  }
  
  return 0;
}
