#include <sys/types.h>
#include <sys/stat.h>
#include <sys/mman.h>
#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>

int get_physical_buffer(int size, int *fd, char **phy_addr)
{
  int *test_buf;
  char modpa_info[256];
  char *token;
  int proc;
  int i;

  *fd = open("/dev/modpa0", O_RDWR);
  if(*fd < 0)
  {
    fprintf(stderr, "Error: cannot open /dev/modpa!\n");
    return -1;
  }

  proc = open("/proc/modpamem",O_RDONLY);
  if(proc < 0)
  {
    fprintf(stderr, "Error: cannot open /proc/modpamem!\n");
    return -1;
  }

  if(read(proc, modpa_info, sizeof(modpa_info)) < 1)
  {
    fprintf(stderr, "Error: cannot read /proc/modpamem!\n");
    return -1;
  }
  close(proc);

  for(token = strtok(modpa_info, ":\n");
      (token != 0) && (strcmp(token, "phy_addr") != 0);
      token = strtok(0, ":\n"));
  token = strtok(0, ":");
  if(token == 0) 
  {
    fprintf(stderr, "Error: cannot get physical address of /dev/modpa!\n");
    return -1;
  }
/*   sscanf(token, "%li", phy_addr); */

  test_buf = (int *) malloc(size);
  for(i = 0; i < size / sizeof(int); i++)
      test_buf[i] = i;
  if(write(*fd, test_buf, size) != size)
  {
    fprintf(stderr, "Error: cannot write to /dev/modpa!\n");
    return -1;
  }

  lseek(*fd, 0, SEEK_SET);
  if(read(*fd, test_buf, size) != size)
  {
    fprintf(stderr, "Error: cannot read from /dev/modpa!\n");
    return -1;
  }
  for(i = 0; i < size / sizeof(int); i++)
    if(test_buf[i] != i)
      printf("Warning: inconsistent message (offset = %d, data = %d)!\n",
	     i * 4, test_buf[i]);

  free(test_buf);

  return 0;
}
