#include <network.h>
#include <timer.h>
#include <mpi.h>

using namespace System;
static Chronometer chrono;
static Network net;

int MPI_Init(int * argc, char *** argv)
{
    chrono.start();
    return MPI_SUCCESS;
}

int MPI_Finalize(void)
{
    return( MPI_SUCCESS );
}

int MPI_Comm_rank(MPI_Comm comm, int * rank)
{
    *rank = Node::id();
    return MPI_SUCCESS;
}

int MPI_Comm_size(MPI_Comm comm, int * size)
{
    *size = Node::peers();
    return MPI_SUCCESS;
}

double MPI_Wtime(void)
{
    return chrono.read();
}

int MPI_Send(void * buf, int count, MPI_Datatype datatype, int dest, int tag,
	     MPI_Comm comm)
{
    if(comm == MPI_COMM_WORLD)
	return net.send(dest, buf, datatype * count);
    else
	return MPI_ERR_COMM;
}

int MPI_Irecv(void * buf, int count, MPI_Datatype datatype, int source, 
	      int tag, MPI_Comm comm, MPI_Request * request)
{
    Node_Id from;
    unsigned int len = datatype * count;
    if(comm == MPI_COMM_WORLD)
	return net.receive(&from, buf, &len);
    else
	return MPI_ERR_COMM;
}

int MPI_Wait(MPI_Request * request, MPI_Status * status)
{
    return MPI_SUCCESS;
}

int MPI_Barrier(MPI_Comm comm)
{
    Node_Id id;
    void * buf = 0;
    unsigned int len = 0;

    if(Node::id() != 0) {
	for(unsigned int i = 0; i < Node::peers(); i++)
	    net.receive(&id, buf, &len);
	net.send(ALL_NODES, 0, 0);
    } else {
	net.send(0, 0, 0);
	net.receive(&id, &buf, &len);
    }

    return  MPI_SUCCESS;
}

int MPI_Allreduce(void * sendbuf, void * recvbuf, int count,
		  MPI_Datatype type, MPI_Op op, MPI_Comm comm)
{
    
    int i;
    if( type == MPI_INT )
    {
        int *pd_sendbuf, *pd_recvbuf;
        pd_sendbuf = (int *) sendbuf;    
        pd_recvbuf = (int *) recvbuf;    
        for( i=0; i<count; i++ )
            *(pd_recvbuf+i) = *(pd_sendbuf+i);
    }
    return( MPI_SUCCESS );
}
  
int MPI_Reduce(void * sendbuf,void * recvbuf,int nitems,MPI_Datatype type,
	       MPI_Op op,int root,MPI_Comm comm)
{
    int i;
    if( type == MPI_INT )
    {
        int *pi_sendbuf, *pi_recvbuf;
        pi_sendbuf = (int *) sendbuf;    
        pi_recvbuf = (int *) recvbuf;    
        for( i=0; i<nitems; i++ )
            *(pi_recvbuf+i) = *(pi_sendbuf+i);
    }
    if( type == MPI_DOUBLE )
    {
        double *pd_sendbuf, *pd_recvbuf;
        pd_sendbuf = (double *) sendbuf;    
        pd_recvbuf = (double *) recvbuf;    
        for( i=0; i<nitems; i++ )
            *(pd_recvbuf+i) = *(pd_sendbuf+i);
    }
    return( MPI_SUCCESS );
}

int MPI_Alltoall(void * sendbuf, int sendcount, MPI_Datatype sendtype,
		 void * recvbuf, int recvcount, MPI_Datatype recvtype,
		 MPI_Comm comm)
{
    int i;
    if( recvtype == MPI_INT )
    {
        int *pd_sendbuf, *pd_recvbuf;
        pd_sendbuf = (int *) sendbuf;    
        pd_recvbuf = (int *) recvbuf;    
        for( i=0; i<sendcount; i++ )
            *(pd_recvbuf+i) = *(pd_sendbuf+i);
    }
    return( MPI_SUCCESS );
}

int MPI_Alltoallv(void * sendbuf, int * sendcounts, int * senddispl,
		  MPI_Datatype sendtype, void * recvbuf, int * recvcounts,
		  int * recvdispl, MPI_Datatype recvtype, MPI_Comm comm)
{
    int i;
    if( recvtype == MPI_INT )
    {
        int *pd_sendbuf, *pd_recvbuf;
        pd_sendbuf = (int *) sendbuf;    
        pd_recvbuf = (int *) recvbuf;    
        for( i=0; i<sendcounts[0]; i++ )
            *(pd_recvbuf+i+recvdispl[0]) = *(pd_sendbuf+i+senddispl[0]);
    }
    return( MPI_SUCCESS );
}
