/*======================================================================*/
/* PCI BUS CONTROLLER IMPLEMENTATION					*/
/*                                                                      */
/* Auth: Guto                                                           */
/*======================================================================*/
#include <pc/pci.h>

/*======================================================================*/
/* pci_init								*/
/*                                                                      */
/* Desc: Should initializes the PCI bus, but as the BIOS usually did it */
/*	 for us, do nothing and go for a coffee.		 	*/
/*                                                                      */
/* Parm: mem_addr <- address in the ix86 linear address space where	*/
/*		     PCI device's memory is mapped			*/
/*	 mem_size <- the PCI address space size in bytes	    	*/
/*                                                                      */
/* Rtrn: 0 on success, -1 on failure                                    */
/*======================================================================*/
int pci_init(void **mem_addr, unsigned int *mem_size)
{
  *mem_addr = (void *)PCI_MEM_PHY_ADDR;
  *mem_size = PCI_MEM_SIZE;

  return 0;
}

/*======================================================================*/
/* pci_get_dev_mem_offs							*/
/*                                                                      */
/* Desc: Returns the offset into the PCI bus address space where one	*/
/*	 can find the memory of a given PCI device.	   		*/
/*                                                                      */
/* Parm: dev_id -> the PCI device's id					*/
/*	 unit   -> the PCI device unit				    	*/
/*                                                                      */
/* Rtrn: PCI device memory offset on success				*/
/*	 -1 on failure                                    		*/
/*======================================================================*/
int pci_get_dev_mem_offs(unsigned short dev_id, int unit)
{
  switch(dev_id)
  {
    case PCI_DEV_ID_MYRINET:
      if(unit == 0)
        return PCI_DEV_MEM_OFF_MYRINET;
  }

  return -1;
}

/*======================================================================*/
/* pci_get_dev_mem_addr							*/
/*                                                                      */
/* Desc: Returns the physical address where one can find the memory of	*/
/*	 a given PCI device.				   		*/
/*                                                                      */
/* Parm: dev_id -> the PCI device's id					*/
/*	 unit   -> the PCI device unit				    	*/
/*                                                                      */
/* Rtrn: PCI device memory address on success				*/
/*	 -1 on failure                                    		*/
/*======================================================================*/
unsigned long pci_get_dev_mem_addr(unsigned short dev_id, int unit)
{
  switch(dev_id)
  {
    case PCI_DEV_ID_MYRINET:
      if(unit == 0)
        return PCI_MEM_PHY_ADDR + PCI_DEV_MEM_OFF_MYRINET;
  }

  return (unsigned) -1;
}
