/*======================================================================*/
/* RTC.C: Functions to Manipulate the MC146818 Processor (real time	*/
/*         clock and battery backup RAM)	                        */
/*                                                                      */
/* Author: Guto								*/
/* Created: 97/05/20							*/
/* Last Updated: 97/05/20                     				*/
/*======================================================================*/
#include <pc/ix86.h>
#include <pc/rtc.h>

/*======================================================================*/
/* GET_REAL_TIME                                                        */
/*                                                                      */
/* Desc: reads the current time from real time clock                    */
/* Rtrn: current time							*/
/*======================================================================*/
int get_real_time(void)
{
  return 0;
}

/*======================================================================*/
/* GET_MEMORY_SIZE	                                                */
/*                                                                      */
/* Desc: returns to amount of memory installed in the system            */
/* Rtrn: memory size in bytes						*/
/*======================================================================*/
int get_memory_size(void)
{
  union
  {
    Ix86_Reg8 b[2];
    Ix86_Reg16 w;
  } main_memory;
 
  union
  {
    Ix86_Reg8 b[2];
    Ix86_Reg16 w;
  } expanded_memory;

  /* Get main memory size in Kbytes */
  ix86_outb(RTC_ADDRESS_PORT, CMOS_MAIN_MEMORY_LSB);
  main_memory.b[0] = ix86_inb(RTC_DATA_PORT);
  ix86_outb(RTC_ADDRESS_PORT, CMOS_MAIN_MEMORY_MSB);
  main_memory.b[1] = ix86_inb(RTC_DATA_PORT);

  /* Get expanded memory size in Kbytes */
  ix86_outb(RTC_ADDRESS_PORT, CMOS_EXPANDED_MEMORY_LSB);
  expanded_memory.b[0] = ix86_inb(RTC_DATA_PORT);
  ix86_outb(RTC_ADDRESS_PORT, CMOS_EXPANDED_MEMORY_MSB);
  expanded_memory.b[1] = ix86_inb(RTC_DATA_PORT);
  
  /* Return the total memory installed in bytes */
  return((main_memory.w + expanded_memory.w) * 1024);
}
