//============================================================================
// MYRINET IMPLEMENTATION
//
// Desc: 
//
// Date: 13 Dec 1999			Auth: Guto
//============================================================================
#include <myrinet.h>
#include <system/debug.h>

BEGIN_SYSTEM_NAMESPACE

Myrinet_Imp::Myrinet_Imp()
{
  debug(DB_TRACE, DB_NETWORK, "Myrinet(this=%p,id=%s)\n", 
	this, get_id().dump());
}

Myrinet_Imp::~Myrinet_Imp()
{
  debug(DB_TRACE, DB_NETWORK, "~Myrinet(this=%p,id=%s)\n", 
	this, get_id().dump());
}

int Myrinet_Imp::reset()
{
  debug(DB_TRACE, DB_NETWORK, "reset()\n");

//  nic->reset();

  return 0;
}

int Myrinet_Imp::send(Network_Id id, const void *buf, unsigned int len)
{
  len = align_length(len);
  if(!node_ok(id)) {
    debug(DB_WARNING, DB_NETWORK, "invalid node id (%d)!\n", id);
//      status.routing_errors++;
    return -1;
  }
//   if(!route_ok(id)) {
//     debug(DB_WARNING, DB_NETWORK, "no route to destination!\n");
// //  	    status.routing_errors++;
//     return -1;
//   }
  if(!length_ok(len)) {
    debug(DB_WARNING, DB_NETWORK, "message is too long (%d bytes)!\n", len);
//  	    status.length_errors++;
    return -1;
  }

  debug(DB_TRACE, DB_NETWORK, "send(id=%d,buf=%p,len=%d,rtc=%x)\n",
	id, buf, len, nic->get_rtc());

  MCP_Message *msg = &shmem->smsg;

  msg->header.node_id = htonl(id);
  msg->header.length = htonl(len);
  msg->body = const_cast<void *>(buf);
  msg->status = htonl(HOST_READY_TO_SEND);
  while(msg->status == htonl(HOST_READY_TO_SEND));

  nic->debug_dma_host_nic();
  nic->debug_dma_nic_net();

  if(msg->status != htonl(SEND_OK)) {
    debug(DB_INFO, DB_NETWORK, "MCP Statistics\n");
    debug(DB_INFO, DB_NETWORK, "  resets: %ld\n",
	  ntohl(shmem->statistics.resets));
    debug(DB_INFO, DB_NETWORK, "  pk sent: %ld\n",
	  ntohl(shmem->statistics.packets_sent));
    debug(DB_INFO, DB_NETWORK, "  pk received: %ld\n",
	  ntohl(shmem->statistics.packets_received));
    debug(DB_INFO, DB_NETWORK, "  pk droped: %ld\n",
	  ntohl(shmem->statistics.packets_droped));
    debug(DB_INFO, DB_NETWORK, "  header_errors: %ld\n",
	  ntohl(shmem->statistics.header_errors));
    debug(DB_INFO, DB_NETWORK, "  crc_errors: %ld\n",
	  ntohl(shmem->statistics.crc_errors));
    debug(DB_INFO, DB_NETWORK, "  trailer_errors: %ld\n",
	  ntohl(shmem->statistics.trailer_errors));
    debug(DB_INFO, DB_NETWORK, "  length_errors: %ld\n",
	  ntohl(shmem->statistics.length_errors));
    debug(DB_INFO, DB_NETWORK, "  routing_errors: %ld\n",
	  ntohl(shmem->statistics.routing_errors));

    return -1;
  }

  return 0;
}

int Myrinet_Imp::receive(Network_Id *id, void *buf, unsigned int *len)
{
  debug(DB_TRACE, DB_NETWORK, "receive(src=%d,buf=%p,len=%d,rtc=%x)\n",
	*id, buf, *len, nic->get_rtc());

  MCP_Message *msg = &shmem->rmsg;

  *len = align_length(*len);

  msg->header.length = htonl(*len);
  msg->body = reinterpret_cast<char *>(buf);
  msg->status = htonl(HOST_READY_TO_RECEIVE);
  while(msg->status == htonl(HOST_READY_TO_RECEIVE));

  nic->debug_dma_net_nic();
  nic->debug_dma_nic_host();

  *id = ntohl(msg->header.node_id);
  *len = ntohl(msg->header.length);

  if(msg->status != htonl(RECEIVE_OK)) {
    debug(DB_INFO, DB_NETWORK, "MCP Statistics\n");
    debug(DB_INFO, DB_NETWORK, "  resets: %ld\n",
	  ntohl(shmem->statistics.resets));
    debug(DB_INFO, DB_NETWORK, "  pk sent: %ld\n",
	  ntohl(shmem->statistics.packets_sent));
    debug(DB_INFO, DB_NETWORK, "  pk received: %ld\n",
	  ntohl(shmem->statistics.packets_received));
    debug(DB_INFO, DB_NETWORK, "  pk droped: %ld\n",
	  ntohl(shmem->statistics.packets_droped));
    debug(DB_INFO, DB_NETWORK, "  header_errors: %ld\n",
	  ntohl(shmem->statistics.header_errors));
    debug(DB_INFO, DB_NETWORK, "  crc_errors: %ld\n",
	  ntohl(shmem->statistics.crc_errors));
    debug(DB_INFO, DB_NETWORK, "  trailer_errors: %ld\n",
	  ntohl(shmem->statistics.trailer_errors));
    debug(DB_INFO, DB_NETWORK, "  length_errors: %ld\n",
	  ntohl(shmem->statistics.length_errors));
    debug(DB_INFO, DB_NETWORK, "  routing_errors: %ld\n",
	  ntohl(shmem->statistics.routing_errors));
  }

  if(!receive_ok(*id, len) || (msg->status != htonl(RECEIVE_OK)))
     return -1;

  return 0;
}

END_SYSTEM_NAMESPACE

