//============================================================================
// MYRINET INITIALIZATION
//
// Desc: 
//
// Date: 13 Dec 1999			Auth: Guto
//============================================================================
#include <system/debug.h>
#include <cpu.h>
#include <io_bus.h>
#include <node.h>
#include <myrinet.h>

#include <pc/pci.h>

#include "myrinet_routes.h"
#include "mcp.h"

BEGIN_SYSTEM_NAMESPACE

static Network_Address Address_Table[CONF_NETWORK_N_NODES] =
  MYRINET_ADDRESS_TABLE;
static Myrinet_Route Routing_Table[CONF_NETWORK_N_NODES][CONF_NETWORK_N_NODES] =
  MYRINET_ROUTING_TABLE;
static struct
{
  int code_addr;
  int code_size;
  unsigned short code_seg[MYRINET_CP_CODE_SIZE / sizeof(short)];
  int data_addr;
  int data_size;
  unsigned short data_seg[MYRINET_CP_DATA_SIZE / sizeof(short)];
  int bss_addr;
  int bss_size;
} MCP_Image =
{
  MYRINET_CP_CODE_ADDR, MYRINET_CP_CODE_SIZE, MYRINET_CP_CODE,
  MYRINET_CP_DATA_ADDR, MYRINET_CP_DATA_SIZE, MYRINET_CP_DATA,
  MYRINET_CP_BSS_ADDR, MYRINET_CP_BSS_SIZE
};

int Myrinet_Imp::init(System_Info *si)
{
  Network_Id id;

  debug(DB_TRACE, DB_INIT, "Myrinet_Imp::init(si=%p)\n", si);

  kprintf("  Starting Myrinet: ");

  Myrinet_NIC *nic = (Myrinet_NIC *)io_bus_get_dev_mem(PCI_DEV_ID_MYRINET, 0);
  if(!nic) {
    kprintf("can't find Myrinet NIC at the PCI bus, failed!\n");
    return -1;
  }

  nic->reset();

  Network_Address addr = nic->get_board_id();

  for(id = 0; (id < CONF_NETWORK_N_NODES)&&(Address_Table[id] != addr); id++);
  if(id == CONF_NETWORK_N_NODES) {
    kprintf("Myrinet NIC with address \"%x%x\" is not registered!\n",
	  *(((unsigned long *)&addr) + 1), *((unsigned long *)&addr));
    return -1;
  }

  if(si->boot_info.node_id == ANY_NODE)
    si->boot_info.node_id = id;
  else
    if(si->boot_info.node_id != id) {
      kprintf(
	"Warning: boot's node id \"%d\" doesn't match driver's \"%d\"!\n",
	si->boot_info.node_id, id);
      kprintf("Using \"%d\"!\n", id);
      si->boot_info.node_id = id;
    }
  
  // Check if we have at least 1 K for MCP's stack
  if((MCP_Image.bss_addr + MCP_Image.bss_size + 1024) > MCP_SHMEM_ADDR) {
    kprintf("Myrinet control program is too big (%d bytes)!\n",
	    MCP_SHMEM_ADDR - 1024);
    return -1;
  }

  nic->int_disable();
  nic->suspend();

  unsigned short *ptr = (unsigned short *)(nic->get_sram()
					   + MCP_Image.code_addr);
  for(unsigned i = 0; i < MCP_Image.code_size / sizeof(short); i++)
    ptr[i] = htons(MCP_Image.code_seg[i]);

  ptr = (unsigned short *)(nic->get_sram() + MCP_Image.data_addr);
  for(unsigned i = 0; i < MCP_Image.data_size / sizeof(short); i++)
    ptr[i] = htons(MCP_Image.data_seg[i]);

  ptr = (unsigned short *)(nic->get_sram() + MCP_Image.bss_addr);
  for(unsigned i = 0; i < MCP_Image.bss_size / sizeof(short); i++)
    ptr[i] = 0;

  Myrinet_Imp *myri = (Myrinet_Imp *)get_object(Abstraction_Id(MYRINET, 0));
  myri->nic = nic;
  myri->set_address(addr);
  myri->set_nid(id);
  myri->shmem = (MCP_Shmem *)(nic->get_sram() + MCP_SHMEM_ADDR);
  for(unsigned i = 0; i < sizeof(MCP_Shmem); i++)
    ((char *)myri->shmem)[i] = 0;
  myri->shmem->status = htonl(NIC_RESET);
  myri->shmem->n_nodes = htonl(n_nodes);
  myri->shmem->route_len = htonl(route_len);
  myri->shmem->node_id = htons(id);
  myri->shmem->phy_addr = htonl(pci_get_dev_mem_addr(PCI_DEV_ID_MYRINET, 0));
//  *nid = id;

  debug(DB_INFO, DB_INIT, "Myrinet={this=%p,nic=%p,id=%d,rtc=%x,rtt={",
	myri, nic, id, nic->get_rtc());

  for(unsigned int i = 0; i < n_nodes; i++) {
    for(unsigned int j = 0; j < route_len; j++)
      myri->shmem->routes[i][j] = Routing_Table[id][i][j];
    debugn(DB_INFO, DB_INIT, "%d,", myri->shmem->routes[i][0]);
  }
  debugn(DB_INFO, DB_INIT, "}}\n");
  
  nic->resume();
  nic->int_enable();

  // Synchronize with MCP
  myri->shmem->status = htonl(HOST_READY);
  while(myri->shmem->status != htonl(NIC_READY));

  kprintf("LANai 4.1, 1Mb, id %d, done!\n", id);
  return 0;
}

END_SYSTEM_NAMESPACE
