/*******************************************************************
 *
 * write_mem: 
 *             writes a string to the MODPA area zone and return the
 *             physical address of the generated buffer
 *
 * Author: Gilles Pokam
 *******************************************************************/

#include <stdio.h>
#include <unistd.h>
#include <sys/mman.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <fcntl.h>
#include <string.h>
#include <errno.h>
#include <stdlib.h>

/*################################################################ 
 * Prototypes definitions 
 *###############################################################*/

int CloseBuf(int fp);
unsigned long GetRecvBuf();
unsigned long ReturnPhysical();
unsigned long GetSendBuf(int* fp);
int PushSendMesg(void* buf,int taille);
void* MmapBuf(int offset, int taille, char* access);

/*################################################################
 *   Global variable 
 *###############################################################*/

char* device  = "/dev/modpa";
int   modpa_fp;

/*#################################################################
 * Write message into DMA buffer
 *################################################################*/

int PushSendMesg(void* buffer,int taille)
{ 
  /* write message into MODPA memory */
  write(modpa_fp,buffer,taille);
  return 0;
}

/*#################################################################
 * Get a send buffer ready to be filled
 *################################################################*/

unsigned long GetSendBuf(int* fp) {

  modpa_fp = open(device,O_WRONLY,0);
  
  if (modpa_fp == -1) {
    printf("failed to open \"%s\"\n",device);
    exit(-1);
  }
 
  *fp = modpa_fp;
  return ReturnPhysical() ;
}

/*###############################################################
 * Close a Buffer
 ###############################################################*/

int CloseBuf(int fp){
  close(modpa_fp);
 return 0;
}

/*#################################################################
 * Get a receive buffer
 *################################################################*/

unsigned long GetRecvBuf() {
 
  modpa_fp = open(device,O_WRONLY,0);
  
  if (modpa_fp == -1) {
    printf("failed to open \"%s\"\n",device);
    exit(-1);
  }
  
  return ReturnPhysical();
}

/*#################################################################
 * Read  message from DMA buffer
 *################################################################*/

void* MmapBuf(int offset, int taille, char* access)
{
  void*  address;
  int fp = open(device,O_RDONLY,0);

  if ( access == "read" )
    address = mmap(0,taille,PROT_READ,MAP_PRIVATE,fp,offset);
  else
    address = mmap(0,taille,PROT_WRITE,MAP_PRIVATE,fp,offset);

  if (address == (void *)-1) {
     fprintf(stderr,"%s: mmap(): %s\n","MmapDmaBuf",strerror(errno));
     exit(1);
   }

  close(fp);   
  printf("virtual address: 0x%x\n",(unsigned int) address);

  return address;
}

/*#################################################################
 * Get physical address of DMA Buffer
 *################################################################*/

unsigned long ReturnPhysical() 
{
  void* buf[256] ;
  unsigned long  physical ;

  /* look up physical address */
   system("get_addr > physical");
   read(open("physical",O_RDONLY),buf,sizeof(buf));
   sscanf((char *)buf,"%li",&physical);
   remove("physical");

   return physical ;
}
