#include <network_adapter.h>

#define MAX_MESSAGE_LEN 65536

int buf[MAX_MESSAGE_LEN / sizeof(int)];

int main(int argc, char *argv[])
{
  Network_Adapter<> na;
  Network_Adapter_Id src;
  char *phy_addr;
  int fd, r_len;

  kprintf("Myrinet Pong Test\n");

  if(!na.is_valid())
  {
    kprintf("Error: cannot access Myrinet!\n");
    return -1;
  }
  
  while(1)
  {
    r_len = sizeof(buf);
    na.receive(&src, phy_addr, &r_len);
    na.send(src, phy_addr, r_len);
  };
  
  kprintf("Finish!\n");

  return 0;
}
