#include <stdio.h>
#include <stdlib.h>
#include <network_adapter.h>

Node_Id Local_Object_Id::lnid;

int main(int argc, char *argv[])
{
  char buf[1024];
  Network_Adapter_Id my_id;
  Network_Adapter_Id dst;
  Network_Adapter na;

//   Network_Adapter na2(na);

//   System_Object_Id id = na2.get_id();
//   Network_Adapter na3(id);
  

  if(argc != 3)
  {
    fprintf(stderr, "Usage: %s <destination> <msg>\n", argv[0]);
    return -1;
  }

#ifdef GENERATE
  if(Network_Adapter::init(&my_id) < 0)
  {
    fprintf(stderr, "Error: can not initialize Myrinet!\n");
    return -1;
  }
  Local_Object_Id::set_local_node_id(my_id);
#endif

  if(!na.is_valid())
  {
    fprintf(stderr, "Error: can not access Myrinet!\n");
    return -1;
  }
  
  dst = atoi(argv[1]);
  for(;;)
    na.send(dst, argv[2], strlen(argv[2]));

  return 0;
}
