#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <network_adapter.h>
#include <chronometer.h>

extern "C" int get_physical_buffer(int size, int *fd, char **phy_addr);

#define N_ITER 1000
#define MAX_MESSAGE_LEN 65536

int send_buffer[MAX_MESSAGE_LEN / sizeof(int)];
int receive_buffer[MAX_MESSAGE_LEN / sizeof(int)];

int main(int argc, char *argv[])
{
  Chronometer chrono;
  Timer_Tick chrono_overhead, time;
  Elapsed_Time latency;
  double bandwidth;
  Network_Adapter<> na;
  Network_Adapter_Id src, dst;
  char *phy_addr;
  int fd, r_len;

  printf("Myrinet Ping Test\n");

  if(argc != 2)
  {
    fprintf(stderr, "Usage: %s <destination>\n", argv[0]);
    return -1;
  }
  dst = atoi(argv[1]);

  if(get_physical_buffer(sizeof(send_buffer), &fd, &phy_addr) < 0)
  {
    fprintf(stderr, "Error: cannot get physical buffer!\n");
    return -1;
  }
  printf("Physical buffer of size %d at %p.\n", sizeof(send_buffer), phy_addr);

  if(!na.is_valid())
  {
    fprintf(stderr, "Error: can not access Myrinet!\n");
    return -1;
  }

  for(int i = 0; i < sizeof(send_buffer) / sizeof(int); i++)
    send_buffer[i] = i;

  chrono.reset();
  chrono.start();
  chrono.stop();
  chrono_overhead = chrono.read();

  printf("Chronometer Overhead: %Lu ticks (%.2f ns)\n",
         chrono_overhead, Elapsed_Time(chrono_overhead) * 1E9);
 
  printf("Packet size(b)\tLat(ticks)\tLat(us)\t\tBandwidth(Kbytes/s)\n");
  for(int len = 4; len <= sizeof(send_buffer); len <<= 1)
  {
    printf("%d\t\t", len);

  //  lseek(fd, 0, SEEK_SET);
  //  write(fd, send_buffer, len);
    na.send(dst, phy_addr, len);
    r_len = sizeof(send_buffer);
    na.receive(&src, phy_addr, &r_len);
  //  lseek(fd, 0, SEEK_SET);
  //  read(fd, receive_buffer, len);

    chrono.reset();
    chrono.start();
    for(int i = 0; i < N_ITER; i++)
    {
   //   lseek(fd, 0, SEEK_SET);
   //   write(fd, send_buffer, len);
      na.send(dst, phy_addr, len);
      r_len = sizeof(send_buffer);
      na.receive(&src, phy_addr, &r_len);
   //   lseek(fd, 0, SEEK_SET);
   //   read(fd, receive_buffer, len);
    }
    chrono.stop();
    time = chrono.read() - chrono_overhead;

    printf("%Lu\t\t", time / N_ITER);

    latency = Elapsed_Time(time) / N_ITER / 2;
    printf("%.2f\t\t", latency * 1E6);

    bandwidth = len / latency;
    printf("%.0f\n", bandwidth / 1024);
  }

  for(int i = 0; i < sizeof(receive_buffer) / sizeof(int); i++)
    if(receive_buffer[i] != i)
      printf("Warning: inconsistent message (offset = %d, data = %d)!\n",
	     i * 4, receive_buffer[i]);

  printf("Finish!\n");

  return 0;
}
