#include <sys/stat.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>

#define MAX_LINE_SIZE 256

int main(int argc, char *argv[])
{
  FILE *dat_file, *c_file;
  char buf[MAX_LINE_SIZE];
  int col = 0, addr, size = 0;

  if(argc != 3){
    fprintf(stderr, "Usage: %s <lanai coff file> <h file>\n", argv[0]);
    return(-1);
  }

  if(!(dat_file = fopen(argv[1], "r"))) {
    fprintf(stderr, "Error: can not open lanai coff file \"%s\"!\n", argv[1]);
    return(-1);
  }

  fgets(buf, MAX_LINE_SIZE, dat_file); 
  if(buf[0] != '@' || buf[1] != 'E' || buf[2] != ' ') {
    fprintf(stderr, "Error: \"%s\" is not a lanai coff file!\n", argv[1]);
    exit(-1);
  }

  if(argv[2][0] == '-')
    c_file = stdout;
  else
    if(!(c_file = fopen(argv[2], "w")))
    {
      fprintf(stderr, "Error: can not write to file \"%s\"!\n", buf);
      return(-1);
    }

  while(fgets(buf, MAX_LINE_SIZE, dat_file))
  {
    switch(buf[0])
    {
      case '@': /* New section */
        switch(buf[1])
        {
          case 'T':
            col = 2;
            addr = strtol(strtok(&buf[3], " "), NULL, 16);
            size = strtol(strtok(NULL, "\n"), NULL, 16);
            fprintf(c_file, "#define MYRINET_CP_CODE_ADDR\t\t%d\n",
	      addr * 2);
            fprintf(c_file, "#define MYRINET_CP_CODE_SIZE\t\t%d\n",
              size * 2);
            fprintf(c_file, "#define MYRINET_CP_CODE\t\t{ \\\n  ");
          break;
          case 'D':
            col = 2;
            addr = strtol(strtok(&buf[3], " "), NULL, 16);
            size = strtol(strtok(NULL, "\n"), NULL, 16);
            fprintf(c_file, "#define MYRINET_CP_DATA_ADDR\t\t%d\n",
	      addr * 2);
            fprintf(c_file, "#define MYRINET_CP_DATA_SIZE\t\t%d\n",
              size * 2);
            fprintf(c_file, "#define MYRINET_CP_DATA\t\t{ \\\n  ");
	    if(size == 0)
	      fprintf(c_file, "}\n\n");
          break;
          case 'B':
            addr = strtol(strtok(&buf[3], " "), NULL, 16);
            size = strtol(strtok(NULL, "\n"), NULL, 16);
            fprintf(c_file, "#define MYRINET_CP_BSS_ADDR\t\t%d\n",
	      addr * 2);
            fprintf(c_file, "#define MYRINET_CP_BSS_SIZE\t\t%d\n",
              size * 2);
           break;
          case 'S':
            return(0);
          break;
          default:
            fprintf(stderr, "Error: %s! is corrupted!\n", argv[1]);
            return(-1);  
        }
      break;
      case '\n': /* Blank line */
      break;
      default:
        fprintf(c_file, "0x%s", strtok(buf, "\n"));
        col += 8;
	size --;
	if(size > 0)
	{
          fputs(", ", c_file);
	  if(col > 71)
	  {
	    col = 2;
	    fprintf(c_file, "\\\n  ");
	  }
	}
	else
          fputs("}\n\n", c_file);
    }
  }

  fclose(dat_file);
  fclose(c_file);
  return 0;
}
