#include <system/kprintf.h>
#include <network.h>

USING_SYSTEM_NAMESPACE

int main()
{
  kprintf("Network Test\n");

  char buffer[] = "test";
  Network na;
  Network na1(1);
  Network na2(na);
  Network na3(na.get_id());

  if(!na.is_valid())
    return -1;

  Network_Id nid = na.get_nid();
  kprintf("Host id = %d\n", nid);

  Network_Address address = na.get_address();
  kprintf("Host MAC = %d\n", address);

  Network_Status status;
  if(na.stat(&status) < 0)
    return -1;
  kprintf("Status = {\n");
  kprintf("  header errors = %d\n", status.header_errors);
  kprintf("}\n");


  if(na.reset() < 0)
    return -1;

  if(na.send(1, (void *)buffer, sizeof(buffer)) < 0)
    return -1;

  unsigned int len = sizeof(buffer);
  Network_Id src;
  if(na.receive(&src, (void *)buffer, &len) < 0)
    return -1;

  return 0;
}
