#include <system/abstractions/network/ethernet.h>
#include <sys/ioctl.h>
#include <unistd.h>
#include <string>
#include <stdio.h>
#include <cpu.h>
#include <traits.h>

__BEGIN_SYS
__BEGIN_IMP

Ethernet::Ethernet()
{
    dbtrc(_type) << "Ethernet()\n";

    if((_sock = socket(PF_PACKET, SOCK_RAW, htons(_protocol))) < 0) {
	perror("Ethernet::Linux::_socket");
	exit(-1);
    }

//     int t = 1;
//     if(set_sockopt(_sock, SOL__SOCKET, SO_BROADCAST, (void *) &t, 4) < 0) {
// 	perror("Ethernet::Linux::set_sockopt");
// 	exit(-1);
//     }
   
    ifreq ifr;
    strcpy(ifr.ifr_name, CONF_ETHERNET_LINUX_DEV);
    if(ioctl(_sock, SIOCGIFINDEX, &ifr) < 0) {
	perror("Ethernet::Linux::ioctl");
	exit(-1);
    }
    dbinf << "Ethernet: using interface " << ifr.ifr_name << "\n";

//     memset(&addr, 0, sizeof(_sockaddr_ll));
//     addr.sll_family = AF_PACKET;
//     addr.sll_protocol = htons(_protocol);
//     addr.sll_ifindex = 0;
//     if(bind(_sock, (_sockaddr *)&addr, sizeof(addr)) < 0) {
// 	perror("");
// 	exit(-1);
//     }  
//     addr.sll_ifindex = ifr.ifr_ifindex;
//     addr.sll_hatype = ARPHRD_ETHER;
//     addr.sll_halen = ETH_HLEN;

    _addr = _arpt[Node::id()];
}

Ethernet::~Ethernet()
{
    dbtrc(_type) << "~Ethernet()\n";

    close(_sock);
}

int Ethernet::send(const Node_Id & r, const void * b, unsigned int l)
{
    dbtrc(_type) << "Network::send(" << r << "," << b << "," << l << ")\n";

    if((r > _peers) && (r != ALL_NODES)) {
	dbwrn(_type) << "Network::send => invalid host\n";
	return -1;
    }

    Frame frame;
    if(r == ALL_NODES)
	frame.header.to = _bcast;
    else
	frame.header.to = _arpt[r];
    frame.header.from = _addr;
    frame.header.protocol = htons(_protocol);

    memcpy(frame.payload, b, l);

    sockaddr_ll to;
    to.sll_family = AF_PACKET;
    to.sll_protocol = frame.header.protocol;
    to.sll_ifindex = 1;
    to.sll_hatype = ARPHRD_ETHER;
    to.sll_pkttype = PACKET_HOST;
    to.sll_halen = ETH_HLEN;
    memcpy(&to.sll_addr, &frame.header.to, _alen);

    l += sizeof(Header);

    if(sendto(_sock, &frame, l, 0,
	      (sockaddr *)&to, sizeof(sockaddr_ll)) < 0) {
	perror("Linux");
	return -1;
    }
    
    dbinf(_type) << "Network::send => header=[t=" << frame.header.to
		 << ",f=" << frame.header.from
		 << ",t=" << ntohs(frame.header.protocol) << "]\n";
 
    return 0;
}

int Ethernet::receive(Node_Id * s, void * b, unsigned int * l)
{
    Frame frame;
    do {	
	if((*l = recvfrom(_sock, &frame, sizeof(Frame), 0, 0, 0)) < 0) {
	    perror("Linux");
	    return -1;
	}
    } while(memcmp(frame.header.to, _addr, _alen) &&
	    memcmp(frame.header.to, _bcast, _alen));

    unsigned int i;
    for(i = 0; 
	(i < _peers) && memcmp(frame.header.from, _arpt[i], _alen);
	i++);
    if(i == _peers)
	*s = ANY_NODE;
    else 
	*s = i;

    *l -= sizeof(Header);
    memcpy(b, frame.payload, *l);

    dbinf(_type) << "Network::receive => header=[t=" << frame.header.to
		 << ",f=" << frame.header.from
		 << ",t=" << ntohs(frame.header.protocol) << "]\n";

    dbtrc(_type) << "Network::receive(" << *s << "," << b << "," << *l << ")\n";

    return 0;
}

__END_IMP
__END_SYS


