#include <system/abstractions/network/ethernet.h>
#include <sys/ioctl.h>
#include <unistd.h>
#include <string>
#include <stdio.h>
#include <cpu.h>
#include <traits.h>

__BEGIN_SYS
__BEGIN_IMP

Ethernet::Ethernet()
{
    dbtrc(type) << "Ethernet()\n";

    if((sock = socket(PF_PACKET, SOCK_RAW, htons(_protocol))) < 0) {
	perror("Ethernet::Linux::socket");
	exit(-1);
    }

    int t = 1;
    if(setsockopt(sock, SOL_SOCKET, SO_DEBUG, (void *) &t, 4) < 0) {
	perror("Ethernet::Linux::setsockopt");
	exit(-1);
    }
    if(setsockopt(sock, SOL_SOCKET, SO_BROADCAST, (void *) &t, 4) < 0) {
	perror("Ethernet::Linux::setsockopt");
	exit(-1);
    }
   
    ifreq ifr;
    strcpy(ifr.ifr_name, CONF_ETHERNET_LINUX_DEV);
    if(ioctl(sock, SIOCGIFINDEX, &ifr) < 0) {
	perror("Ethernet::Linux::ioctl");
	exit(-1);
    }
    dbinf << "Ethernet: using interface " << ifr.ifr_name << "\n";

    memset(&addr, 0, sizeof(sockaddr_ll));
    addr.sll_family = AF_PACKET;
    addr.sll_protocol = htons(_protocol);
//     addr.sll_ifindex = 0;
//     if(bind(sock, (sockaddr *)&addr, sizeof(addr)) < 0) {
// 	perror("");
// 	exit(-1);
//     }
    
    addr.sll_ifindex = ifr.ifr_ifindex;
    addr.sll_hatype = ARPHRD_ETHER;
//     addr.sll_pkttype = 2;
    addr.sll_halen = ETH_HLEN;
//     addr.sll_addr[0] = 0xff;
//     addr.sll_addr[1] = 0xff;
//     addr.sll_addr[2] = 0xff;
//     addr.sll_addr[3] = 0xff;
//     addr.sll_addr[4] = 0xff;
//     addr.sll_addr[5] = 0xff;
//     addr.sll_addr[6] = 0x00;
//     addr.sll_addr[7] = 0x00;
}

Ethernet::~Ethernet()
{
    dbtrc(type) << "~Ethernet()\n";

    close(sock);
}

int Ethernet::send(const Node_Id & r, const void * b, unsigned int l)
{
    dbtrc(type) << "Network::send(" << r << "," << b << "," 
			<< l << ")\n";

    Frame frame;
//     frame.header.to = arp_table[r];
//     frame.header.from = arp_table[Node::id()];
    memset(frame.header.to, 0xff, _alen);
    frame.header.from = frame.header.to;
    frame.header.protocol = htons(_protocol);
    memcpy(frame.payload, b, l);


    sockaddr_ll to;
    to.sll_family = AF_PACKET;
    to.sll_protocol = htons(_protocol);
    to.sll_ifindex = 1;
    to.sll_hatype = ARPHRD_ETHER;
    to.sll_pkttype = PACKET_LOOPBACK;
    to.sll_halen = _alen;
    memcpy(&to.sll_addr, &frame.header.to, _alen);

    if(sendto(sock, &frame.payload, 200, 0,
	      (sockaddr *)&to, sizeof(sockaddr_ll)) < 0) {
	perror("Linux");
	return -1;
    }

    dbinf(type) << "Network::send => header = [t=";
    //   for(unsigned int i = 0; i < alen; i++)
	dbinf << (void *)(int)frame.header.to[5];
    dbinf << ",f=";
    //   for(unsigned int i = 0; i < alen; i++)
	dbinf << (void *)(int)frame.header.from[5];
    dbinf << ",t=" << (void *)(int)ntohs(frame.header.protocol) << "]\n";
 
    return 0;
}

int Ethernet::receive(Node_Id * s, void * b, unsigned int * l)
{
    Frame frame;
//    do {
	if((*l = recvfrom(sock, &frame, sizeof(Frame), 0, 0, 0)) < 0) {
	    perror("Linux");
	    return -1;
	}
//   } while (frame.header.protocol != htons(_protocol));

    unsigned int i;
    for(i = 0; i < _nodes; i++)
	if(arp_table[i] = frame.header.from)
	    break;
    if(i == _nodes)
	*s = ANY_NODE;
    else 
	*s = i;

    *l -= sizeof(Header);
    memcpy(b, frame.payload, *l);

    dbinf(type) << "Network::receive => header = [t=";
    //   for(unsigned int i = 0; i < alen; i++)
	dbinf << (void *)(int)frame.header.to[5];
    dbinf << ",f=";
    //   for(unsigned int i = 0; i < alen; i++)
	dbinf << (void *)(int)frame.header.from[5];
    dbinf << ",t=" << (void *)(int)ntohs(frame.header.protocol) << "]\n";

    dbtrc(type) << "Network::receive(" << *s << "," << b << "," << *l << ")\n";

    return 0;
}

__END_IMP
__END_SYS


