#include <system/abstractions/synchronizer/condition.h>

__BEGIN_SYS
__BEGIN_IMP

Condition::Condition()
{
    dbtrc(type) << "Condition()\n";
    pthread_cond_init(&cond, NULL);
}

Condition::~Condition()
{
    dbtrc(type) << "~Condition()\n";
    pthread_cond_destroy(&cond); 
}

void Condition::lock() {
    dbtrc(type) << "Condition::lock()\n";
    pthread_mutex_lock(&mutex); 
}

void Condition::unlock() { 
    dbtrc(type) << "Condition::unlock()\n";
    pthread_mutex_unlock(&mutex); 
}

void Condition::signal()
{
    dbtrc(type) << "Condition::signal()\n";
    pthread_cond_signal(&cond); 
}

void Condition::broadcast()
{
    dbtrc(type) << "Condition::broadcast()\n";
    pthread_cond_broadcast(&cond); 
}

void Condition::wait()
{
    dbtrc(type) << "Condition()::wait\n";
    pthread_cond_wait(&cond, &mutex); 
}

__END_IMP
__END_SYS


