#include <iostream>
#include <thread.h>
#include <synchronizer.h>

using namespace System;
using namespace std;

const int iterations = 100;
Mutex chopstick[5];

int philosopher(int n)
{
    cout << "I'm the philosopher " << n << "\n";

    int first = (n < 4)? n : 0;
    int second = (n < 4)? n + 1 : 4;

    for(int i = iterations; i > 0; i--) {
 	cout << "Philosopher " << n << " thinking ...\n";
	chopstick[first].lock();   // get first chopstick
	chopstick[second].lock();   // get second chopstick
	cout << "Philosopher " << n << " eating ...\n";
	chopstick[first].unlock();   // release first chopstick
	chopstick[second].unlock();   // release second chopstick
	yield();
    }

    return iterations;
}

int main()
{
    cout << "The Philosopher's Dinner\n";

    for(int i = 0; i < 5; i++)
	chopstick[i].lock();

    Thread * phil[5];
    for(int i = 0; i < 5; i++)
	phil[i] = new Thread(&philosopher, i);

    cout << "Philosophers are alife and hungry!\n";

    for(int i = 0; i < 1000000000; i++);
    for(int i = 0; i < 5; i++)
	chopstick[i].unlock();

    cout << "The dinner is served!\n";

    for(int i = 0; i < 5; i++) {
	int ret;
	if(phil[i]->join(&ret)) {
	    cerr << "Error: cannot join thread!\n";
	    return 1;
	}
	cout << "Philosopher " << i << " ate " << ret << " times \n";
    }

    cout << "The end!\n";
    
    return 0;
}
