#include <system/abstractions/synchronizer/semaphore.h>

__BEGIN_SYS
__BEGIN_IMP

Semaphore::Semaphore(int v = 1)
{
    dbtrc(type) << "Semaphore(v=" << v << ")\n";
    sem_init(&sem, 0, v); 
}

Semaphore::~Semaphore()
{
    dbtrc(type) << "~Semaphore()\n";
    sem_destroy(&sem);
}

void Semaphore::p()
{
    dbtrc(type) << "Semaphore::p()\n";
    sem_wait(&sem);
}

void Semaphore::v()
{
    dbtrc(type) << "Semaphore::v()\n";
    sem_post(&sem);
}

__END_IMP
__END_SYS


