#include <system/abstractions/thread/cooperative.h>

__BEGIN_SYS
__BEGIN_IMP

Cooperative_Thread::Cooperative_Thread(int ( * const e)(int),
				       int a = 0,
				       const Thread_State & s = READY)
    : state(s), entry(e), argument(a)
{

    if(pthread_create(&thread, 0, &initializer, this))
	thread = 0;
}

void Cooperative_Thread::stat(Thread_Status * s) {
    Exclusive_Thread::stat(s);
    s->state = state;
}

void Cooperative_Thread::suspend() {
    dbtrc << "Thread::suspend()\n";
    state = SUSPENDED;
    while(state != READY);
}

void Cooperative_Thread::resume() {
    dbtrc << "Thread::resume()\n";
    state = READY;
}

int Cooperative_Thread::join(int *ret) {
    dbtrc << "Thread::join(" << ret << ")\n";
    return pthread_join(thread, (void **)ret); 
}

int Cooperative_Thread::pass() {
    dbtrc << "Cooperative_Thread::Thread::pass()\n";
    dbwrn << "Thread::pass() not implemented!\n";
    return 1;
}

__END_IMP
__END_SYS


