#include <system/aspects/protected/checked.h>

__BEGIN_SYS

Checked::Checked()
{
    dbtrc << "Checked()Eduardo\n";
}

Checked::~Checked()
{
    dbtrc << "~Checked()\n";
}

void Checked::setOwner(Id * owner) {
   _owner = new Id(*owner);
   dbtrc << "setOwner " << _owner;
}

Id & Checked::getRestrictedId(Rights & grants) {

  Id * temp = new Id(*_owner); 
  int owner = _owner->getRand();
  Random restrictedCap = 0;
  int aux = 0;
  int AB, CD, AD, BC = 0;


  //calcular AB
  AB = owner & 0xFFFF0000;

  //calcular CD
  CD = owner << 16 ;

  //calcular AD
  AD = owner >> 16;
  AD = AD & 0x0000FF00;
  aux = owner & 0x000000FF;
  AD = AD | aux;

  //calcular BC
  BC = owner >> 8;

  aux = AB ^ CD;
  aux = aux & 0xFFFF0000;
  restrictedCap = AD ^ BC;
  restrictedCap = restrictedCap & 0x0000FFFF;
  restrictedCap = aux | restrictedCap;

  temp->setRand(restrictedCap);
  temp->setRights(grants);
  return *temp;

}

bool Checked::check(const Id  & id)
{
  dbtrc << _owner << "\n";
  Id copyId(id);
  Rights aux = 0;
  dbtrc << "*** Entrando no metodo check: cap. ownwer = " << _owner->getRand() << " cap. restricted = " << copyId.getRand() << " ***\n";
  //verifica protecao
  if (getRestrictedId(aux).getRand() == copyId.getRand()) {
    printf("\nAcesso permitido !!!\n");
    return true;
  }
  else {
    printf("\nAcesso negado!\n");
    return false;
  }
}


bool Checked::access(int methodIndex) { //comeca com 0
   dbtrc << "*** Entrando no metodo access\n";
   Rights owner = _owner->getRights();
   methodIndex = owner >> methodIndex;
   methodIndex = methodIndex & 0x00000001;
   if(methodIndex > 0)
        return true;
  return false;
}

__END_SYS
