#include <system/kprintf.h>
#include <simple_chronometer.h>

#define ITERACTIONS 10

USING_SYSTEM_NAMESPACE

int main()
{
  Simple_Chronometer chrono;

  kprintf("Simple Chronometer Test\n");

  kprintf("  Chronometer Resolution: %u ns\n",
	  (unsigned)(chrono.get_resolution()*1E9));

  Timer_Tick lap, min = 10000, max = 0, avg = 0;
  for(int i = 0; i < ITERACTIONS; i++) {
    chrono.reset();
    chrono.start();
    chrono.stop();

    lap = chrono.get_ticks();
    if(lap < min)
      min = lap;
    if(lap > max)
      max = lap;
    avg += lap;

    kprintf("  Chronometer overhead: %u ticks (%u ns)\n",
	    (unsigned)chrono.get_ticks(), (unsigned)(chrono.read() * 1E9));
  }
  avg/= ITERACTIONS;

  kprintf("  Minimun chronometer overhead: %u ticks (%u ns)\n",
	    (unsigned)min, (unsigned)(min * 1E9 * chrono.get_resolution()));
  kprintf("  Average chronometer overhead: %u ticks (%u ns)\n",
	    (unsigned)avg, (unsigned)(avg * 1E9 * chrono.get_resolution()));
  kprintf("  Maximun chronometer overhead: %u ticks (%u ns)\n",
	    (unsigned)max, (unsigned)(max * 1E9 * chrono.get_resolution()));
  
  return 0;
}
