#include <system/kprintf.h>
#include <cpu.h>

#define ITERACTIONS 10

USING_SYSTEM_NAMESPACE

int main()
{
  kprintf("CPU Test\n");

  CPU cpu;

  kprintf("  clock: %u Hz\n", cpu.get_clock());

  union{
    struct{
      CPU_Reg32 lo;
      CPU_Reg32 hi;
    } v_32;
    CPU_Reg64 v_64;
  } ts;
  for(int i = 0; i < ITERACTIONS; i++) {
    ts.v_64 = cpu.get_time_stamp();
    kprintf("  time-stamp: %x%x\n", ts.v_32.hi, ts.v_32.lo);
  }

  return 0;
}
